/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.objectstorage;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.james.blob.objectstorage.swift.Credentials;
import org.apache.james.blob.objectstorage.swift.Identity;
import org.apache.james.blob.objectstorage.swift.Region;
import org.apache.james.blob.objectstorage.swift.SwiftKeystone2ObjectStorage;
import org.apache.james.blob.objectstorage.swift.TenantName;
import org.apache.james.blob.objectstorage.swift.UserName;
import org.apache.james.modules.objectstorage.SwiftConfigurationReader;

public class SwiftKeystone2ConfigurationReader
implements SwiftConfigurationReader {
    static final String OBJECTSTORAGE_SWIFT_KEYSTONE_2_USERNAME = "objectstorage.swift.keystone2.username";
    static final String OBJECTSTORAGE_SWIFT_KEYSTONE_2_TENANTNAME = "objectstorage.swift.keystone2.tenantname";

    public static SwiftKeystone2ObjectStorage.Configuration readSwiftConfiguration(Configuration configuration) {
        String endpointStr = configuration.getString("objectstorage.swift.endpoint", null);
        String crendentialsStr = configuration.getString("objectstorage.swift.credentials", null);
        String userNameStr = configuration.getString(OBJECTSTORAGE_SWIFT_KEYSTONE_2_USERNAME, null);
        String tenantNameStr = configuration.getString(OBJECTSTORAGE_SWIFT_KEYSTONE_2_TENANTNAME, null);
        Preconditions.checkArgument((endpointStr != null ? 1 : 0) != 0, (Object)"objectstorage.swift.endpoint is a mandatory configuration value");
        Preconditions.checkArgument((crendentialsStr != null ? 1 : 0) != 0, (Object)"objectstorage.swift.credentials is a mandatory configuration value");
        Preconditions.checkArgument((userNameStr != null ? 1 : 0) != 0, (Object)"objectstorage.swift.keystone2.username is a mandatory configuration value");
        Preconditions.checkArgument((tenantNameStr != null ? 1 : 0) != 0, (Object)"objectstorage.swift.keystone2.tenantname is a mandatory configuration value");
        URI endpoint = URI.create(endpointStr);
        Credentials credentials = Credentials.of((String)crendentialsStr);
        UserName userName = UserName.of((String)userNameStr);
        TenantName tenantName = TenantName.of((String)tenantNameStr);
        Identity identity = Identity.of((TenantName)tenantName, (UserName)userName);
        Optional<Region> region = Optional.ofNullable(configuration.getString("objectstorage.swift.region", null)).map(Region::of);
        return SwiftKeystone2ObjectStorage.configBuilder().endpoint(endpoint).credentials(credentials).region(region).identity(identity).build();
    }
}

