/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.objectstorage;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.james.blob.objectstorage.swift.Credentials;
import org.apache.james.blob.objectstorage.swift.DomainId;
import org.apache.james.blob.objectstorage.swift.DomainName;
import org.apache.james.blob.objectstorage.swift.IdentityV3;
import org.apache.james.blob.objectstorage.swift.Project;
import org.apache.james.blob.objectstorage.swift.ProjectName;
import org.apache.james.blob.objectstorage.swift.Region;
import org.apache.james.blob.objectstorage.swift.SwiftKeystone3ObjectStorage;
import org.apache.james.blob.objectstorage.swift.UserName;
import org.apache.james.modules.objectstorage.SwiftConfigurationReader;
import org.apache.james.util.OptionalUtils;

public class SwiftKeystone3ConfigurationReader
implements SwiftConfigurationReader {
    static final String OBJECTSTORAGE_SWIFT_KEYSTONE_3_USER_NAME = "objectstorage.swift.keystone3.user.name";
    static final String OBJECTSTORAGE_SWIFT_KEYSTONE_3_USER_DOMAIN = "objectstorage.swift.keystone3.user.domain";
    private static final String OBJECTSTORAGE_SWIFT_KEYSTONE_3_DOMAIN_ID = "objectstorage.swift.keystone3.scope.domainid";
    static final String OBJECTSTORAGE_SWIFT_KEYSTONE_3_PROJECT_NAME = "objectstorage.swift.keystone3.scope.project.name";
    private static final String OBJECTSTORAGE_SWIFT_KEYSTONE_3_PROJECT_DOMAIN_NAME = "objectstorage.swift.keystone3.scope.project.domainname";
    private static final String OBJECTSTORAGE_SWIFT_KEYSTONE_3_PROJECT_DOMAIN_ID = "objectstorage.swift.keystone3.scope.project.domainid";

    public static SwiftKeystone3ObjectStorage.Configuration readSwiftConfiguration(Configuration configuration) {
        String endpointStr = configuration.getString("objectstorage.swift.endpoint", null);
        String crendentialsStr = configuration.getString("objectstorage.swift.credentials", null);
        Preconditions.checkArgument((endpointStr != null ? 1 : 0) != 0, (Object)"objectstorage.swift.endpoint is a mandatory configuration value");
        Preconditions.checkArgument((crendentialsStr != null ? 1 : 0) != 0, (Object)"objectstorage.swift.credentials is a mandatory configuration value");
        URI endpoint = URI.create(endpointStr);
        Credentials credentials = Credentials.of((String)crendentialsStr);
        IdentityV3 identity = SwiftKeystone3ConfigurationReader.readIdentity(configuration);
        Optional<DomainId> domainScope = Optional.ofNullable(configuration.getString(OBJECTSTORAGE_SWIFT_KEYSTONE_3_DOMAIN_ID, null)).map(DomainId::of);
        Optional<Project> projectScope = SwiftKeystone3ConfigurationReader.readProjectScope(configuration);
        Optional<Region> region = Optional.ofNullable(configuration.getString("objectstorage.swift.region", null)).map(Region::of);
        return SwiftKeystone3ObjectStorage.configBuilder().endpoint(endpoint).credentials(credentials).region(region).identity(identity).domainId(domainScope).project(projectScope).build();
    }

    private static IdentityV3 readIdentity(Configuration configuration) {
        String userNameStr = configuration.getString(OBJECTSTORAGE_SWIFT_KEYSTONE_3_USER_NAME, null);
        String domainNameStr = configuration.getString(OBJECTSTORAGE_SWIFT_KEYSTONE_3_USER_DOMAIN, null);
        Preconditions.checkArgument((userNameStr != null ? 1 : 0) != 0, (Object)"objectstorage.swift.keystone3.user.name is a mandatory configuration value");
        Preconditions.checkArgument((domainNameStr != null ? 1 : 0) != 0, (Object)"objectstorage.swift.keystone3.user.domain is a mandatory configuration value");
        UserName userName = UserName.of((String)userNameStr);
        DomainName userDomain = DomainName.of((String)domainNameStr);
        return IdentityV3.of((DomainName)userDomain, (UserName)userName);
    }

    private static Optional<Project> readProjectScope(Configuration configuration) {
        Optional<ProjectName> projectName = Optional.ofNullable(configuration.getString(OBJECTSTORAGE_SWIFT_KEYSTONE_3_PROJECT_NAME, null)).map(ProjectName::of);
        Optional<DomainName> projectDomainName = Optional.ofNullable(configuration.getString(OBJECTSTORAGE_SWIFT_KEYSTONE_3_PROJECT_DOMAIN_NAME, null)).map(DomainName::of);
        Optional<DomainId> projectDomainId = Optional.ofNullable(configuration.getString(OBJECTSTORAGE_SWIFT_KEYSTONE_3_PROJECT_DOMAIN_ID, null)).map(DomainId::of);
        return OptionalUtils.or((Optional[])new Optional[]{projectName.flatMap(project -> projectDomainName.map(domain -> Project.of((ProjectName)project, (DomainName)domain))), projectName.flatMap(project -> projectDomainId.map(domain -> Project.of((ProjectName)project, (DomainId)domain))), projectName.map(Project::of)});
    }
}

