/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.logging.Log;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.fetchmail.Account;
import org.apache.james.fetchmail.DynamicAccount;
import org.apache.james.fetchmail.ParsedConfiguration;
import org.apache.james.fetchmail.StoreProcessor;
import org.apache.james.lifecycle.Configurable;
import org.apache.james.lifecycle.LogEnabled;
import org.apache.james.services.MailServer;
import org.apache.james.user.api.UsersRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchMail
implements Runnable,
LogEnabled,
Configurable {
    private boolean fieldFetching = false;
    private ParsedConfiguration fieldConfiguration;
    private List<ParsedDynamicAccountParameters> fieldParsedDynamicAccountParameters;
    private List<Account> fieldStaticAccounts;
    private Session fieldSession;
    private Map<DynamicAccountKey, DynamicAccount> fieldDynamicAccounts;
    private MailServer fieldServer;
    private UsersRepository fieldLocalUsers;
    private DNSService dnsServer;
    private Log logger;

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.setSessionParameters(configuration);
        ParsedConfiguration parsedConfiguration = new ParsedConfiguration(configuration, this.logger, this.getServer(), this.getLocalUsers(), this.getDNSService());
        this.setParsedConfiguration(parsedConfiguration);
        List allAccounts = configuration.configurationsAt("accounts");
        if (allAccounts.size() < 1) {
            throw new ConfigurationException("Missing <accounts> section.");
        }
        if (allAccounts.size() > 1) {
            throw new ConfigurationException("Too many <accounts> sections, there must be exactly one");
        }
        HierarchicalConfiguration accounts = (HierarchicalConfiguration)allAccounts.get(0);
        if (!accounts.getKeys().hasNext()) {
            throw new ConfigurationException("Missing <account> section.");
        }
        List accountsChildren = accounts.getRoot().getChildren();
        int i = 0;
        for (HierarchicalConfiguration.Node accountsChild : accountsChildren) {
            String accountsChildName = accountsChild.getName();
            SubnodeConfiguration accountsChildConfig = accounts.configurationAt(accountsChildName);
            if ("alllocal".equals(accountsChildName)) {
                this.getParsedDynamicAccountParameters().add(new ParsedDynamicAccountParameters(i, (Configuration)accountsChildConfig));
                continue;
            }
            if ("account".equals(accountsChildName)) {
                this.getStaticAccounts().add(new Account(i, parsedConfiguration, accountsChildConfig.getString("[@user]"), accountsChildConfig.getString("[@password]"), accountsChildConfig.getString("[@recipient]"), accountsChildConfig.getBoolean("[@ignorercpt-header]"), accountsChildConfig.getString("[@customrcpt-header]", ""), this.getSession()));
                continue;
            }
            throw new ConfigurationException("Illegal token: <" + accountsChildName + "> in <accounts>");
        }
        ++i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.isFetching()) {
            this.logger.info((Object)"Triggered fetch cancelled. A fetch is already in progress.");
            return;
        }
        try {
            try {
                this.setFetching(true);
                this.logger.info((Object)"Fetcher starting fetches");
                this.logJavaMailProperties();
                this.updateDynamicAccounts();
                ArrayList<Account> mergedAccounts = new ArrayList<Account>(this.getDynamicAccounts().size() + this.getStaticAccounts().size());
                mergedAccounts.addAll(this.getDynamicAccounts().values());
                mergedAccounts.addAll(this.getStaticAccounts());
                Collections.sort(mergedAccounts);
                StringBuilder logMessage = new StringBuilder(64);
                logMessage.append("Processing ");
                logMessage.append(this.getStaticAccounts().size());
                logMessage.append(" static accounts and ");
                logMessage.append(this.getDynamicAccounts().size());
                logMessage.append(" dynamic accounts.");
                this.logger.info((Object)logMessage.toString());
                Iterator accounts = mergedAccounts.iterator();
                while (accounts.hasNext()) {
                    try {
                        new StoreProcessor((Account)accounts.next()).process();
                    }
                    catch (MessagingException ex) {
                        this.logger.error((Object)"A MessagingException has terminated processing of this Account", (Throwable)ex);
                    }
                }
                Object var6_6 = null;
            }
            catch (Exception ex) {
                this.logger.error((Object)"An Exception has terminated this fetch.", (Throwable)ex);
                Object var6_7 = null;
                this.logger.info((Object)"Fetcher completed fetches");
                this.setFetching(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.logger.info((Object)"Fetcher completed fetches");
            this.setFetching(false);
            throw throwable;
        }
        this.logger.info((Object)"Fetcher completed fetches");
        this.setFetching(false);
    }

    private void logJavaMailProperties() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Session properties:");
            Properties properties = this.getSession().getProperties();
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = (String)properties.get(key);
                if (val.length() > 40) {
                    val = val.substring(0, 37) + "...";
                }
                this.logger.debug((Object)(key + "=" + val));
            }
        }
    }

    protected boolean isFetching() {
        return this.fieldFetching;
    }

    protected void setFetching(boolean fetching) {
        this.fieldFetching = fetching;
    }

    protected MailServer getServer() {
        return this.fieldServer;
    }

    protected ParsedConfiguration getConfiguration() {
        return this.fieldConfiguration;
    }

    protected void setParsedConfiguration(ParsedConfiguration configuration) {
        this.fieldConfiguration = configuration;
    }

    protected UsersRepository getLocalUsers() {
        return this.fieldLocalUsers;
    }

    protected DNSService getDNSService() {
        return this.dnsServer;
    }

    @Resource(name="dnsservice")
    public void setDNSService(DNSService dns) {
        this.dnsServer = dns;
    }

    @Resource(name="mailserver")
    public void setMailServer(MailServer mailserver) {
        this.fieldServer = mailserver;
    }

    @Resource(name="localusersrepository")
    public void setUsersRepository(UsersRepository urepos) {
        this.fieldLocalUsers = urepos;
    }

    public final void setLog(Log logger) {
        this.logger = logger;
    }

    protected List<Account> getStaticAccounts() {
        if (null == this.getStaticAccountsBasic()) {
            this.updateStaticAccounts();
            return this.getStaticAccounts();
        }
        return this.fieldStaticAccounts;
    }

    private List<Account> getStaticAccountsBasic() {
        return this.fieldStaticAccounts;
    }

    protected void setStaticAccounts(List<Account> accounts) {
        this.fieldStaticAccounts = accounts;
    }

    protected void updateStaticAccounts() {
        this.setStaticAccounts(this.computeStaticAccounts());
    }

    protected void updateParsedDynamicAccountParameters() {
        this.setParsedDynamicAccountParameters(this.computeParsedDynamicAccountParameters());
    }

    protected void updateDynamicAccounts() throws ConfigurationException {
        this.setDynamicAccounts(this.computeDynamicAccounts());
    }

    protected List<Account> computeStaticAccounts() {
        return new ArrayList<Account>();
    }

    protected List<ParsedDynamicAccountParameters> computeParsedDynamicAccountParameters() {
        return new ArrayList<ParsedDynamicAccountParameters>();
    }

    protected Map<DynamicAccountKey, DynamicAccount> computeDynamicAccounts() throws ConfigurationException {
        HashMap<DynamicAccountKey, DynamicAccount> newAccounts = new HashMap<DynamicAccountKey, DynamicAccount>(this.getLocalUsers().countUsers() * this.getParsedDynamicAccountParameters().size());
        Map<DynamicAccountKey, DynamicAccount> oldAccounts = this.getDynamicAccountsBasic();
        if (null == oldAccounts) {
            oldAccounts = new HashMap<DynamicAccountKey, DynamicAccount>(0);
        }
        Iterator<ParsedDynamicAccountParameters> parameterIterator = this.getParsedDynamicAccountParameters().iterator();
        while (parameterIterator.hasNext()) {
            Map<DynamicAccountKey, DynamicAccount> accounts = this.computeDynamicAccounts(oldAccounts, parameterIterator.next());
            Iterator<DynamicAccountKey> oldAccountsIterator = oldAccounts.keySet().iterator();
            while (oldAccountsIterator.hasNext()) {
                if (!accounts.containsKey(oldAccountsIterator.next())) continue;
                oldAccountsIterator.remove();
            }
            newAccounts.putAll(accounts);
        }
        return newAccounts;
    }

    protected Map<DynamicAccountKey, DynamicAccount> getDynamicAccounts() throws ConfigurationException {
        if (null == this.getDynamicAccountsBasic()) {
            this.updateDynamicAccounts();
            return this.getDynamicAccounts();
        }
        return this.fieldDynamicAccounts;
    }

    private Map<DynamicAccountKey, DynamicAccount> getDynamicAccountsBasic() {
        return this.fieldDynamicAccounts;
    }

    protected void setDynamicAccounts(Map<DynamicAccountKey, DynamicAccount> dynamicAccounts) {
        this.fieldDynamicAccounts = dynamicAccounts;
    }

    protected Map<DynamicAccountKey, DynamicAccount> computeDynamicAccounts(Map<DynamicAccountKey, DynamicAccount> oldAccounts, ParsedDynamicAccountParameters parameters) throws ConfigurationException {
        HashMap<DynamicAccountKey, DynamicAccount> accounts = new HashMap<DynamicAccountKey, DynamicAccount>(this.getLocalUsers().countUsers());
        Iterator usersIterator = this.getLocalUsers().list();
        while (usersIterator.hasNext()) {
            String userName = (String)usersIterator.next();
            DynamicAccountKey key = new DynamicAccountKey(userName, parameters.getSequenceNumber());
            DynamicAccount account = oldAccounts.get(key);
            if (null == account) {
                account = new DynamicAccount(parameters.getSequenceNumber(), this.getConfiguration(), userName, parameters.getUserPrefix(), parameters.getUserSuffix(), parameters.getPassword(), parameters.getRecipientPrefix(), parameters.getRecipientSuffix(), parameters.isIgnoreRecipientHeader(), parameters.getCustomRecipientHeader(), this.getSession());
            }
            accounts.put(key, account);
        }
        return accounts;
    }

    protected void resetDynamicAccounts() {
        this.setDynamicAccounts(null);
    }

    protected List<ParsedDynamicAccountParameters> getParsedDynamicAccountParameters() {
        if (null == this.getParsedDynamicAccountParametersBasic()) {
            this.updateParsedDynamicAccountParameters();
            return this.getParsedDynamicAccountParameters();
        }
        return this.fieldParsedDynamicAccountParameters;
    }

    private List<ParsedDynamicAccountParameters> getParsedDynamicAccountParametersBasic() {
        return this.fieldParsedDynamicAccountParameters;
    }

    protected void setParsedDynamicAccountParameters(List<ParsedDynamicAccountParameters> parsedDynamicAccountParameters) {
        this.fieldParsedDynamicAccountParameters = parsedDynamicAccountParameters;
    }

    protected Session getSession() {
        Session session = null;
        session = this.getSessionBasic();
        if (null == session) {
            this.updateSession();
            return this.getSession();
        }
        return session;
    }

    private Session getSessionBasic() {
        return this.fieldSession;
    }

    protected Session computeSession() {
        return Session.getInstance((Properties)new Properties(System.getProperties()));
    }

    protected void updateSession() {
        this.setSession(this.computeSession());
    }

    protected void setSession(Session session) {
        this.fieldSession = session;
    }

    protected void setSessionParameters(HierarchicalConfiguration configuration) throws ConfigurationException {
        if (configuration.getKeys("javaMailProperties.property").hasNext()) {
            Properties properties = this.getSession().getProperties();
            List allProperties = configuration.configurationsAt("javaMailProperties.property");
            for (int i = 0; i < allProperties.size(); ++i) {
                HierarchicalConfiguration propConf = (HierarchicalConfiguration)allProperties.get(i);
                properties.setProperty(propConf.getString("[@name]"), propConf.getString("[@value]"));
                if (!this.logger.isDebugEnabled()) continue;
                StringBuilder messageBuffer = new StringBuilder("Set property name: ");
                messageBuffer.append(propConf.getString("[@name]"));
                messageBuffer.append(" to: ");
                messageBuffer.append(propConf.getString("[@value]"));
                this.logger.debug((Object)messageBuffer.toString());
            }
        }
    }

    private static final class ParsedDynamicAccountParameters {
        private String fieldUserPrefix;
        private String fieldUserSuffix;
        private String fieldPassword;
        private int fieldSequenceNumber;
        private boolean fieldIgnoreRecipientHeader;
        private String fieldRecipientPrefix;
        private String fieldRecipientSuffix;
        private String customRecipientHeader;

        private ParsedDynamicAccountParameters() {
        }

        public ParsedDynamicAccountParameters(int sequenceNumber, Configuration configuration) throws ConfigurationException {
            this();
            this.setSequenceNumber(sequenceNumber);
            this.setUserPrefix(configuration.getString("[@userprefix]", ""));
            this.setUserSuffix(configuration.getString("[@usersuffix]", ""));
            this.setRecipientPrefix(configuration.getString("[@recipientprefix]", ""));
            this.setRecipientSuffix(configuration.getString("[@recipientsuffix]", ""));
            this.setPassword(configuration.getString("[@password]"));
            this.setIgnoreRecipientHeader(configuration.getBoolean("[@ignorercpt-header]"));
            this.setCustomRecipientHeader(configuration.getString("[@customrcpt-header]", ""));
        }

        public String getCustomRecipientHeader() {
            return this.customRecipientHeader;
        }

        public String getRecipientPrefix() {
            return this.fieldRecipientPrefix;
        }

        public String getRecipientSuffix() {
            return this.fieldRecipientSuffix;
        }

        public String getUserPrefix() {
            return this.fieldUserPrefix;
        }

        public String getUserSuffix() {
            return this.fieldUserSuffix;
        }

        public void setCustomRecipientHeader(String customRecipientHeader) {
            this.customRecipientHeader = customRecipientHeader;
        }

        protected void setRecipientPrefix(String recipientprefix) {
            this.fieldRecipientPrefix = recipientprefix;
        }

        protected void setRecipientSuffix(String recipientsuffix) {
            this.fieldRecipientSuffix = recipientsuffix;
        }

        protected void setUserPrefix(String userprefix) {
            this.fieldUserPrefix = userprefix;
        }

        protected void setUserSuffix(String userSuffix) {
            this.fieldUserSuffix = userSuffix;
        }

        public String getPassword() {
            return this.fieldPassword;
        }

        protected void setIgnoreRecipientHeader(boolean ignoreRecipientHeader) {
            this.fieldIgnoreRecipientHeader = ignoreRecipientHeader;
        }

        protected void setPassword(String password) {
            this.fieldPassword = password;
        }

        public boolean isIgnoreRecipientHeader() {
            return this.fieldIgnoreRecipientHeader;
        }

        public int getSequenceNumber() {
            return this.fieldSequenceNumber;
        }

        protected void setSequenceNumber(int sequenceNumber) {
            this.fieldSequenceNumber = sequenceNumber;
        }
    }

    private static final class DynamicAccountKey {
        private String fieldUserName;
        private int fieldSequenceNumber;

        private DynamicAccountKey() {
        }

        public DynamicAccountKey(String userName, int sequenceNumber) {
            this();
            this.setUserName(userName);
            this.setSequenceNumber(sequenceNumber);
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return this.getUserName().equals(((DynamicAccountKey)obj).getUserName()) && this.getSequenceNumber() == ((DynamicAccountKey)obj).getSequenceNumber();
        }

        public int hashCode() {
            return this.getUserName().hashCode() ^ this.getSequenceNumber();
        }

        public int getSequenceNumber() {
            return this.fieldSequenceNumber;
        }

        public String getUserName() {
            return this.fieldUserName;
        }

        protected void setSequenceNumber(int sequenceNumber) {
            this.fieldSequenceNumber = sequenceNumber;
        }

        protected void setUserName(String userName) {
            this.fieldUserName = userName;
        }
    }
}

