/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.fetchmail.FetchMail;
import org.apache.james.fetchmail.FetchSchedulerMBean;
import org.apache.james.lifecycle.Configurable;
import org.apache.james.lifecycle.LogEnabled;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.services.MailServer;
import org.apache.james.user.api.UsersRepository;

public class FetchScheduler
implements FetchSchedulerMBean,
LogEnabled,
Configurable {
    private HierarchicalConfiguration conf;
    private ScheduledExecutorService scheduler;
    private volatile boolean enabled = false;
    private List<ScheduledFuture<?>> schedulers = new ArrayList();
    private DNSService dns;
    private MailServer mailserver;
    private UsersRepository urepos;
    private Log logger;
    private MailQueue queue;
    private MailQueueFactory queueFactory;

    @Resource(name="mailQueueFactory")
    public void setMailQueueFactory(MailQueueFactory queueFactory) {
        this.queueFactory = queueFactory;
    }

    @Resource(name="scheduler")
    public void setScheduledExecutorService(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    @Resource(name="dnsservice")
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    @Resource(name="mailserver")
    public void setMailServer(MailServer mailserver) {
        this.mailserver = mailserver;
    }

    @Resource(name="localusersrepository")
    public void setUsersRepository(UsersRepository urepos) {
        this.urepos = urepos;
    }

    public final void setLog(Log logger) {
        this.logger = logger;
    }

    public final void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.conf = config;
    }

    @PostConstruct
    public void init() throws Exception {
        this.enabled = this.conf.getBoolean("[@enabled]", false);
        if (this.enabled) {
            this.queue = this.queueFactory.getQueue("spool");
            List fetchConfs = this.conf.configurationsAt("fetch");
            for (int i = 0; i < fetchConfs.size(); ++i) {
                HierarchicalConfiguration fetchConf = (HierarchicalConfiguration)fetchConfs.get(i);
                Long interval = fetchConf.getLong("interval");
                FetchMail fetcher = new FetchMail();
                fetcher.setLog(this.logger);
                fetcher.setDNSService(this.dns);
                fetcher.setMailServer(this.mailserver);
                fetcher.setUsersRepository(this.urepos);
                fetcher.setMailQueue(this.queue);
                fetcher.configure(fetchConf);
                this.schedulers.add(this.scheduler.scheduleWithFixedDelay(fetcher, 0L, interval, TimeUnit.MILLISECONDS));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"FetchMail Started");
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"FetchMail Disabled");
        }
    }

    @PreDestroy
    public void dispose() {
        if (this.enabled) {
            this.logger.info((Object)"FetchMail dispose...");
            Iterator<ScheduledFuture<?>> schedulersIt = this.schedulers.iterator();
            while (schedulersIt.hasNext()) {
                schedulersIt.next().cancel(false);
            }
            this.logger.info((Object)"FetchMail ...dispose end");
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }
}

