/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.commons.logging.Log;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.fetchmail.Account;
import org.apache.james.fetchmail.ParsedConfiguration;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.services.MailServer;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.MailAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessorAbstract {
    private String fieldAttributePrefix;
    private Account fieldAccount;

    private ProcessorAbstract() {
    }

    protected ProcessorAbstract(Account account) {
        this();
        this.setAccount(account);
    }

    protected String getDefaultDomainName() {
        return this.getConfiguration().getDefaultDomainName();
    }

    protected String getDefaultLocalPart() {
        return "FETCHMAIL-SERVICE";
    }

    protected List<String> getDeferredRecipientNotFoundMessageIDs() {
        return this.getAccount().getDeferredRecipientNotFoundMessageIDs();
    }

    protected String getFetchTaskName() {
        return this.getConfiguration().getFetchTaskName();
    }

    protected String getHost() {
        return this.getConfiguration().getHost();
    }

    protected String getJavaMailFolderName() {
        return this.getConfiguration().getJavaMailFolderName();
    }

    protected String getJavaMailProviderName() {
        return this.getConfiguration().getJavaMailProviderName();
    }

    protected Log getLogger() {
        return this.getConfiguration().getLogger();
    }

    protected String getPassword() {
        return this.getAccount().getPassword();
    }

    protected MailAddress getRecipient() {
        return this.getAccount().getRecipient();
    }

    protected int getRemoteReceivedHeaderIndex() {
        return this.getConfiguration().getRemoteReceivedHeaderIndex();
    }

    protected MailServer getServer() {
        return this.getConfiguration().getServer();
    }

    protected DNSService getDNSServer() {
        return this.getConfiguration().getDNSServer();
    }

    protected Session getSession() {
        return this.getAccount().getSession();
    }

    protected UsersRepository getLocalUsers() {
        return this.getConfiguration().getLocalUsers();
    }

    protected String getUser() {
        return this.getAccount().getUser();
    }

    protected boolean isFetchAll() {
        return this.getConfiguration().isFetchAll();
    }

    protected boolean isDeferRecipientNotFound() {
        return this.getConfiguration().isDeferRecipientNotFound();
    }

    protected boolean isIgnoreRecipientHeader() {
        return this.getAccount().isIgnoreRecipientHeader();
    }

    protected String getCustomRecipientHeader() {
        return this.getAccount().getCustomRecipientHeader();
    }

    protected boolean isLeave() {
        return this.getConfiguration().isLeave();
    }

    protected boolean isMarkSeen() {
        return this.getConfiguration().isMarkSeen();
    }

    protected boolean isLeaveBlacklisted() {
        return this.getConfiguration().isLeaveBlacklisted();
    }

    protected boolean isLeaveRemoteRecipient() {
        return this.getConfiguration().isLeaveRemoteRecipient();
    }

    protected boolean isLeaveUserUndefined() {
        return this.getConfiguration().isLeaveUserUndefined();
    }

    protected boolean isLeaveRemoteReceivedHeaderInvalid() {
        return this.getConfiguration().isLeaveRemoteReceivedHeaderInvalid();
    }

    protected boolean isLeaveMaxMessageSizeExceeded() {
        return this.getConfiguration().isLeaveMaxMessageSizeExceeded();
    }

    protected boolean isLeaveUndeliverable() {
        return this.getConfiguration().isLeaveUndeliverable();
    }

    protected boolean isRejectUserUndefined() {
        return this.getConfiguration().isRejectUserUndefined();
    }

    protected boolean isRejectRemoteReceivedHeaderInvalid() {
        return this.getConfiguration().isRejectRemoteReceivedHeaderInvalid();
    }

    protected boolean isRejectMaxMessageSizeExceeded() {
        return this.getConfiguration().isRejectMaxMessageSizeExceeded();
    }

    protected boolean isRejectBlacklisted() {
        return this.getConfiguration().isRejectBlacklisted();
    }

    protected boolean isRejectRemoteRecipient() {
        return this.getConfiguration().isRejectRemoteRecipient();
    }

    protected boolean isMarkBlacklistedSeen() {
        return this.getConfiguration().isMarkBlacklistedSeen();
    }

    protected boolean isMarkRecipientNotFoundSeen() {
        return this.getConfiguration().isMarkRecipientNotFoundSeen();
    }

    protected boolean isLeaveRecipientNotFound() {
        return this.getConfiguration().isLeaveRecipientNotFound();
    }

    protected boolean isRejectRecipientNotFound() {
        return this.getConfiguration().isRejectRecipientNotFound();
    }

    protected boolean isMarkRemoteRecipientSeen() {
        return this.getConfiguration().isMarkRemoteRecipientSeen();
    }

    protected boolean isMarkUserUndefinedSeen() {
        return this.getConfiguration().isMarkUserUndefinedSeen();
    }

    protected boolean isMarkRemoteReceivedHeaderInvalidSeen() {
        return this.getConfiguration().isMarkRemoteReceivedHeaderInvalidSeen();
    }

    protected boolean isMarkMaxMessageSizeExceededSeen() {
        return this.getConfiguration().isMarkMaxMessageSizeExceededSeen();
    }

    protected boolean isMarkUndeliverableSeen() {
        return this.getConfiguration().isMarkUndeliverableSeen();
    }

    protected boolean isOpenReadOnly() {
        return this.getConfiguration().isOpenReadOnly();
    }

    protected boolean isRecurse() {
        return this.getConfiguration().isRecurse();
    }

    public abstract void process() throws MessagingException;

    protected Set<MailAddress> getBlacklist() {
        return this.getConfiguration().getBlacklist();
    }

    protected ParsedConfiguration getConfiguration() {
        return this.getAccount().getParsedConfiguration();
    }

    protected String getAttributePrefix() {
        String value = null;
        value = this.getAttributePrefixBasic();
        if (null == value) {
            this.updateAttributePrefix();
            return this.getAttributePrefix();
        }
        return value;
    }

    private String getAttributePrefixBasic() {
        return this.fieldAttributePrefix;
    }

    protected String computeAttributePrefix() {
        return this.getClass().getPackage().getName() + ".";
    }

    protected void setAttributePrefix(String attributePrefix) {
        this.fieldAttributePrefix = attributePrefix;
    }

    protected void updateAttributePrefix() {
        this.setAttributePrefix(this.computeAttributePrefix());
    }

    public Account getAccount() {
        return this.fieldAccount;
    }

    protected void setAccount(Account account) {
        this.fieldAccount = account;
    }

    protected int getMaxMessageSizeLimit() {
        return this.getConfiguration().getMaxMessageSizeLimit();
    }

    protected MailQueue getMailQueue() {
        return this.getConfiguration().getMailQueue();
    }
}

