/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import javax.annotation.Resource;
import javax.net.ssl.SSLEngine;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.main.ImapRequestStreamHandler;
import org.apache.james.imapserver.netty.IMAPServerMBean;
import org.apache.james.imapserver.netty.ImapStreamChannelUpstreamHandler;
import org.apache.james.protocols.impl.ChannelGroupHandler;
import org.apache.james.protocols.impl.TimeoutHandler;
import org.apache.james.socket.netty.AbstractConfigurableAsyncServer;
import org.apache.james.socket.netty.ConnectionCountHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.connection.ConnectionLimitUpstreamHandler;
import org.jboss.netty.handler.connection.ConnectionPerIpLimitUpstreamHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class IMAPServer
extends AbstractConfigurableAsyncServer
implements ImapConstants,
IMAPServerMBean {
    private static final String softwaretype = "JAMES IMAP4rev1 Server ";
    private final ConnectionCountHandler countHandler = new ConnectionCountHandler();
    private String hello;
    private ImapProcessor processor;
    private ImapEncoder encoder;
    private ImapDecoder decoder;

    @Resource(name="imapDecoder")
    public void setImapDecoder(ImapDecoder decoder) {
        this.decoder = decoder;
    }

    @Resource(name="imapEncoder")
    public void setImapEncoder(ImapEncoder encoder) {
        this.encoder = encoder;
    }

    @Resource(name="imapProcessor")
    public void setImapProcessor(ImapProcessor processor) {
        this.processor = processor;
    }

    public void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        this.hello = "JAMES IMAP4rev1 Server  Server " + this.getHelloName() + " is ready.";
    }

    public int getDefaultPort() {
        return 143;
    }

    public String getServiceType() {
        return "IMAP Service";
    }

    protected ChannelPipelineFactory createPipelineFactory(final ChannelGroup group) {
        return new ChannelPipelineFactory(){
            private final ChannelGroupHandler groupHandler;
            private final HashedWheelTimer timer;
            private static final int TIMEOUT = 1800;
            {
                this.groupHandler = new ChannelGroupHandler(group);
                this.timer = new HashedWheelTimer();
            }

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("groupHandler", (ChannelHandler)this.groupHandler);
                pipeline.addLast("timeoutHandler", (ChannelHandler)new TimeoutHandler((Timer)this.timer, 1800));
                pipeline.addLast("connectionLimit", (ChannelHandler)new ConnectionLimitUpstreamHandler(IMAPServer.this.connectionLimit));
                pipeline.addLast("connectionPerIpLimit", (ChannelHandler)new ConnectionPerIpLimitUpstreamHandler(IMAPServer.this.connPerIP));
                if (IMAPServer.this.isSSLSocket()) {
                    SSLEngine engine = IMAPServer.this.getSSLContext().createSSLEngine();
                    engine.setUseClientMode(false);
                    pipeline.addFirst("sslHandler", (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast("connectionCountHandler", (ChannelHandler)IMAPServer.this.countHandler);
                ImapRequestStreamHandler handler = new ImapRequestStreamHandler(IMAPServer.this.decoder, IMAPServer.this.processor, IMAPServer.this.encoder);
                if (IMAPServer.this.isStartTLSSupported()) {
                    pipeline.addLast("coreHandler", (ChannelHandler)new ImapStreamChannelUpstreamHandler(IMAPServer.this.hello, handler, IMAPServer.this.getLogger(), IMAPServer.this.getTimeout(), IMAPServer.this.getSSLContext().createSSLEngine()));
                } else {
                    pipeline.addLast("coreHandler", (ChannelHandler)new ImapStreamChannelUpstreamHandler(IMAPServer.this.hello, handler, IMAPServer.this.getLogger(), IMAPServer.this.getTimeout()));
                }
                return pipeline;
            }
        };
    }

    public int getCurrentConnections() {
        return this.countHandler.getCurrentConnectionCount();
    }

    public boolean getStartTLSSupported() {
        return this.isStartTLSSupported();
    }

    public int getMaximumConcurrentConnections() {
        return this.connectionLimit;
    }
}

