/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.commons.logging.Log;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.ImapRequestStreamHandler;
import org.apache.james.imap.main.ImapSessionImpl;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.StreamHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class ImapStreamChannelUpstreamHandler
extends StreamHandler {
    private final Log logger;
    private final String hello;
    private final ImapRequestStreamHandler handler;
    private SSLEngine engine;
    private static final String IMAP_SESSION = "IMAP_SESSION";
    private static final String BUFFERED_OUT = "BUFFERED_OUT";

    public ImapStreamChannelUpstreamHandler(String hello, ImapRequestStreamHandler handler, Log logger, long readTimeout) {
        this(hello, handler, logger, readTimeout, null);
    }

    public ImapStreamChannelUpstreamHandler(String hello, ImapRequestStreamHandler handler, Log logger, long readTimeout, SSLEngine engine) {
        super((Timer)new HashedWheelTimer(), readTimeout, TimeUnit.SECONDS);
        this.logger = logger;
        this.hello = hello;
        this.handler = handler;
        this.engine = engine;
    }

    protected void processStreamIo(ChannelHandlerContext ctx, InputStream in, OutputStream out) {
        ImapSessionImpl imapSession = (ImapSessionImpl)this.getAttachment(ctx).get(IMAP_SESSION);
        Channel channel = ctx.getChannel();
        StartTLSOutputStream bufferedOut = new StartTLSOutputStream(out);
        this.getAttachment(ctx).put(BUFFERED_OUT, bufferedOut);
        while (channel.isConnected() && this.handler.handleRequest(in, (OutputStream)bufferedOut, (ImapSession)imapSession)) {
        }
        if (imapSession != null) {
            imapSession.logout();
        }
        this.logger.debug((Object)("Thread execution complete for session " + channel.getId()));
        channel.close();
    }

    public void channelBound(final ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ImapSessionImpl imapsession = new ImapSessionImpl(){

            public boolean startTLS() {
                if (!this.supportStartTLS()) {
                    return false;
                }
                ((StartTLSOutputStream)ImapStreamChannelUpstreamHandler.this.getAttachment(ctx).get(ImapStreamChannelUpstreamHandler.BUFFERED_OUT)).bufferTillCRLF();
                SslHandler filter = new SslHandler(ImapStreamChannelUpstreamHandler.this.engine, true);
                filter.getEngine().setUseClientMode(false);
                ctx.getPipeline().addFirst("sslHandler", (ChannelHandler)filter);
                return true;
            }

            public boolean supportStartTLS() {
                return ImapStreamChannelUpstreamHandler.this.engine != null;
            }
        };
        imapsession.setLog(this.logger);
        this.getAttachment(ctx).put(IMAP_SESSION, imapsession);
        super.channelBound(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.getChannel().write((Object)ChannelBuffers.copiedBuffer((byte[])("* OK " + this.hello + " " + new String(ImapConstants.BYTES_LINE_END)).getBytes()));
        super.channelConnected(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.logger.debug((Object)"Error while processing imap request", e.getCause());
        ImapSessionImpl imapSession = (ImapSessionImpl)this.getAttachment(ctx).get(IMAP_SESSION);
        if (imapSession != null) {
            imapSession.logout();
        }
        ctx.getChannel().close();
        super.exceptionCaught(ctx, e);
    }

    private final class StartTLSOutputStream
    extends FilterOutputStream {
        private int lastChar;
        private boolean bufferData;
        private final ChannelBuffer buffer;

        public StartTLSOutputStream(OutputStream out) {
            super(out);
            this.bufferData = false;
            this.buffer = ChannelBuffers.dynamicBuffer();
        }

        public final synchronized void bufferTillCRLF() {
            this.bufferData = true;
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (this.bufferData) {
                for (int i = off; i < len; ++i) {
                    this.write(b[i]);
                }
            } else {
                this.out.write(b, off, len);
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public synchronized void write(int b) throws IOException {
            if (this.bufferData) {
                this.buffer.writeByte((int)((byte)b));
                if (b == 10 && this.lastChar == 13) {
                    byte[] line = new byte[this.buffer.capacity()];
                    this.buffer.getBytes(0, line);
                    this.out.write(line);
                    this.bufferData = false;
                }
                this.lastChar = b;
            } else {
                this.out.write(b);
            }
        }
    }
}

