/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.github.fge.lambdas.functions.ThrowingFunction;
import com.google.common.base.MoreObjects;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class MemoryReferenceWithCounterTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"memory-reference-task-with-counter");
    private final ThrowingFunction<AtomicLong, Task.Result> task;
    private final AtomicLong counter = new AtomicLong(0L);

    public MemoryReferenceWithCounterTask(ThrowingFunction<AtomicLong, Task.Result> task) {
        this.task = task;
    }

    public Task.Result run() {
        try {
            return (Task.Result)this.task.apply((Object)this.counter);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.counter.get(), Clock.systemUTC().instant()));
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final long count;
        private final Instant timestamp;

        public AdditionalInformation(long count, Instant timestamp) {
            this.count = count;
            this.timestamp = timestamp;
        }

        public long getCount() {
            return this.count;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public boolean equals(Object that) {
            if (that instanceof AdditionalInformation) {
                return Objects.equals(this.count, ((AdditionalInformation)that).getCount()) && Objects.equals(this.timestamp, ((AdditionalInformation)that).timestamp);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.count, this.timestamp);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("timestamp", (Object)this.timestamp).toString();
        }
    }
}

