/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.domain.AuthenticationResponse;
import org.jclouds.rest.InvocationContext;

public class ParseAuthenticationResponseFromHeaders
implements Function<HttpResponse, AuthenticationResponse>,
InvocationContext<ParseAuthenticationResponseFromHeaders> {
    @Resource
    protected Logger logger = Logger.NULL;
    private String hostToReplace;

    public AuthenticationResponse apply(HttpResponse from) {
        HttpUtils.releasePayload((HttpMessage)from);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : from.getHeaders().entries()) {
            if (!((String)entry.getKey()).toLowerCase().endsWith("-Url".toLowerCase())) continue;
            builder.put(entry.getKey(), (Object)this.getURI((String)entry.getValue()));
        }
        AuthenticationResponse response = new AuthenticationResponse((String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Auth-Token"), (Object)"X-Auth-Token"), (Map<String, URI>)builder.build());
        this.logger.debug("will connect to: ", new Object[]{response});
        return response;
    }

    protected URI getURI(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        URI toReturn = URI.create(headerValue);
        if (!"127.0.0.1".equals(toReturn.getHost())) {
            return toReturn;
        }
        return Uris.uriBuilder((URI)toReturn).host(this.hostToReplace).build();
    }

    public ParseAuthenticationResponseFromHeaders setContext(HttpRequest request) {
        String host = request.getEndpoint().getHost();
        return this.setHostToReplace(host);
    }

    @VisibleForTesting
    ParseAuthenticationResponseFromHeaders setHostToReplace(String hostToReplace) {
        this.hostToReplace = hostToReplace;
        return this;
    }
}

