/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.netty.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.stream.ChunkedFile;

public class ChunkedFileInputStream
extends InputStream {
    private static final int CHUNK_SIZE = 8192;
    private ChunkedFile chunks;
    private ChannelBuffer chunk;
    private IOException ex;

    public ChunkedFileInputStream(String filename, long offset, long length) {
        this(new File(filename), offset, length);
    }

    public ChunkedFileInputStream(File file, long offset, long length) {
        try {
            this.chunks = new ChunkedFile(new RandomAccessFile(file, "r"), offset, length, 8192);
        }
        catch (IOException ex) {
            this.ex = ex;
        }
    }

    private ChannelBuffer getChunk() throws Exception {
        if (this.ex != null) {
            throw this.ex;
        }
        if (this.chunk == null) {
            this.chunk = (ChannelBuffer)ChannelBuffer.class.cast(this.chunks.nextChunk());
        }
        if (this.chunk != null) {
            if (this.chunk.readableBytes() < 1 && this.chunks.hasNextChunk()) {
                this.chunk = (ChannelBuffer)ChannelBuffer.class.cast(this.chunks.nextChunk());
                if (this.chunk.readableBytes() < 1) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return this.chunk;
    }

    @Override
    public int read() throws IOException {
        try {
            ChannelBuffer chunk = this.getChunk();
            if (chunk == null) {
                return -1;
            }
            if (chunk.readableBytes() < 1) {
                return -1;
            }
            int readIndex = chunk.readerIndex();
            byte abyte = chunk.getByte(readIndex);
            chunk.readerIndex(readIndex + 1);
            return abyte;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            ChannelBuffer chunk = this.getChunk();
            if (chunk == null) {
                return -1;
            }
            int readable = chunk.readableBytes();
            if (readable < 1) {
                return -1;
            }
            if (readable > len) {
                readable = len;
            }
            int readIndex = chunk.readerIndex();
            chunk.getBytes(readIndex, b, off, readable);
            chunk.readerIndex(readIndex + readable);
            return readable;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.chunks.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

