/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.okhttp;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.http.internal.JavaUrlHttpCommandExecutorService;
import org.jclouds.io.ContentMetadataCodec;

@Singleton
public class OkHttpCommandExecutorService
extends JavaUrlHttpCommandExecutorService {
    @Inject
    public OkHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, @Named(value="jclouds.io-worker-threads") ListeningExecutorService ioExecutor, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, Function<URI, Proxy> proxyForURI) throws SecurityException, NoSuchFieldException {
        super(utils, contentMetadataCodec, ioExecutor, retryHandler, ioRetryHandler, errorHandler, wire, verifier, untrustedSSLContextProvider, proxyForURI);
    }

    protected HttpURLConnection initConnection(HttpRequest request) throws IOException {
        OkHttpClient client = new OkHttpClient();
        URL url = request.getEndpoint().toURL();
        client.setProxy((Proxy)this.proxyForURI.apply((Object)request.getEndpoint()));
        if (url.getProtocol().equalsIgnoreCase("https")) {
            if (this.utils.relaxHostname()) {
                client.setHostnameVerifier(this.verifier);
            }
            if (this.sslContextSupplier != null) {
                client.setSslSocketFactory(((SSLContext)this.sslContextSupplier.get()).getSocketFactory());
            } else if (this.utils.trustAllCerts()) {
                client.setSslSocketFactory(((SSLContext)this.untrustedSSLContextProvider.get()).getSocketFactory());
            }
        }
        return client.open(url);
    }

    protected void configureRequestHeaders(HttpURLConnection connection, HttpRequest request) {
        super.configureRequestHeaders(connection, request);
        if (request.getFirstHeaderOrNull("Accept") == null) {
            connection.setRequestProperty("Accept", "*/*");
        }
    }
}

