/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.blobstore.functions.BlobToAzureBlob;
import org.jclouds.azureblob.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.azureblob.blobstore.functions.ListBlobsResponseToResourceList;
import org.jclouds.azureblob.blobstore.functions.ListOptionsToListBlobsOptions;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.http.options.GetOptions;

@Singleton
public class AzureBlobStore
extends BaseBlobStore {
    private final AzureBlobClient sync;
    private final ContainerToResourceMetadata container2ResourceMd;
    private final ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions;
    private final ListBlobsResponseToResourceList azure2BlobStoreResourceList;
    private final AzureBlobToBlob azureBlob2Blob;
    private final BlobToAzureBlob blob2AzureBlob;
    private final BlobPropertiesToBlobMetadata blob2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;

    @Inject
    AzureBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, AzureBlobClient sync, ContainerToResourceMetadata container2ResourceMd, ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions, ListBlobsResponseToResourceList azure2BlobStoreResourceList, AzureBlobToBlob azureBlob2Blob, BlobToAzureBlob blob2AzureBlob, BlobPropertiesToBlobMetadata blob2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions) {
        super(context, blobUtils, defaultLocation, locations);
        this.sync = (AzureBlobClient)Preconditions.checkNotNull((Object)sync, (Object)"sync");
        this.container2ResourceMd = (ContainerToResourceMetadata)Preconditions.checkNotNull((Object)container2ResourceMd, (Object)"container2ResourceMd");
        this.blobStore2AzureContainerListOptions = (ListOptionsToListBlobsOptions)Preconditions.checkNotNull((Object)blobStore2AzureContainerListOptions, (Object)"blobStore2AzureContainerListOptions");
        this.azure2BlobStoreResourceList = (ListBlobsResponseToResourceList)Preconditions.checkNotNull((Object)azure2BlobStoreResourceList, (Object)"azure2BlobStoreResourceList");
        this.azureBlob2Blob = (AzureBlobToBlob)Preconditions.checkNotNull((Object)azureBlob2Blob, (Object)"azureBlob2Blob");
        this.blob2AzureBlob = (BlobToAzureBlob)Preconditions.checkNotNull((Object)blob2AzureBlob, (Object)"blob2AzureBlob");
        this.blob2BlobMd = (BlobPropertiesToBlobMetadata)Preconditions.checkNotNull((Object)blob2BlobMd, (Object)"blob2BlobMd");
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
    }

    public PageSet<? extends StorageMetadata> list() {
        return new Function<BoundedSet<ContainerProperties>, PageSet<? extends StorageMetadata>>(){

            public PageSet<? extends StorageMetadata> apply(BoundedSet<ContainerProperties> from) {
                return new PageSetImpl(Iterables.transform(from, (Function)AzureBlobStore.this.container2ResourceMd), from.getNextMarker());
            }
        }.apply(this.sync.listContainers(ListOptions.Builder.includeMetadata()));
    }

    public boolean containerExists(String container) {
        return this.sync.containerExists(container);
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.sync.createContainer(container, new CreateContainerOptions[0]);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        ListBlobsOptions azureOptions = this.blobStore2AzureContainerListOptions.apply(options);
        return this.azure2BlobStoreResourceList.apply(this.sync.listBlobs(container, azureOptions.includeMetadata()));
    }

    public void deleteContainer(String container) {
        this.sync.deleteContainer(container);
    }

    public boolean blobExists(String container, String key) {
        return this.sync.blobExists(container, key);
    }

    public Blob getBlob(String container, String key, org.jclouds.blobstore.options.GetOptions options) {
        GetOptions azureOptions = this.blob2ObjectGetOptions.apply(options);
        return this.azureBlob2Blob.apply(this.sync.getBlob(container, key, azureOptions));
    }

    public String putBlob(String container, Blob blob) {
        return this.sync.putBlob(container, this.blob2AzureBlob.apply(blob));
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    public void removeBlob(String container, String key) {
        this.sync.deleteBlob(container, key);
    }

    public BlobMetadata blobMetadata(String container, String key) {
        return this.blob2BlobMd.apply(this.sync.getBlobProperties(container, key));
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        throw new UnsupportedOperationException("please use deleteContainer");
    }

    public boolean createContainerInLocation(Location location, String container, org.jclouds.blobstore.options.CreateContainerOptions options) {
        CreateContainerOptions createContainerOptions = new CreateContainerOptions();
        if (options.isPublicRead()) {
            createContainerOptions.withPublicAccess(PublicAccess.CONTAINER);
        }
        return this.sync.createContainer(container, createContainerOptions);
    }
}

