/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.options;

import com.google.common.collect.Multimap;
import org.jclouds.azure.storage.options.CreateOptions;
import org.jclouds.azureblob.domain.PublicAccess;

public class CreateContainerOptions
extends CreateOptions {
    public static final CreateContainerOptions NONE = new CreateContainerOptions();

    public CreateContainerOptions withMetadata(Multimap<String, String> metadata) {
        return (CreateContainerOptions)super.withMetadata(metadata);
    }

    public CreateContainerOptions withPublicAccess(PublicAccess access) {
        if (access != PublicAccess.PRIVATE) {
            this.headers.put((Object)"x-ms-blob-public-access", (Object)access.name().toLowerCase());
        }
        return this;
    }

    public static class Builder {
        public static CreateContainerOptions withPublicAccess(PublicAccess access) {
            CreateContainerOptions options = new CreateContainerOptions();
            return options.withPublicAccess(access);
        }

        public static CreateContainerOptions withMetadata(Multimap<String, String> metadata) {
            CreateContainerOptions options = new CreateContainerOptions();
            return options.withMetadata((Multimap)metadata);
        }
    }
}

