/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.domain.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Set;
import org.jclouds.azure.storage.domain.internal.BoundedHashSet;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ListBlobsResponse;

public class HashSetListBlobsResponse
extends BoundedHashSet<BlobProperties>
implements ListBlobsResponse {
    protected final String delimiter;
    protected final Set<String> blobPrefixes = Sets.newHashSet();

    public HashSetListBlobsResponse(Iterable<BlobProperties> contents, URI url, String prefix, String marker, Integer maxResults, String nextMarker, String delimiter, Iterable<String> blobPrefixes) {
        super(contents, url, prefix, marker, maxResults, nextMarker);
        this.delimiter = delimiter;
        Iterables.addAll(this.blobPrefixes, blobPrefixes);
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public Set<String> getBlobPrefixes() {
        return this.blobPrefixes;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.blobPrefixes == null ? 0 : this.blobPrefixes.hashCode());
        result = 31 * result + (this.delimiter == null ? 0 : this.delimiter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashSetListBlobsResponse other = (HashSetListBlobsResponse)obj;
        if (this.blobPrefixes == null ? other.blobPrefixes != null : !this.blobPrefixes.equals(other.blobPrefixes)) {
            return false;
        }
        return !(this.delimiter == null ? other.delimiter != null : !this.delimiter.equals(other.delimiter));
    }

    public String toString() {
        return "[blobPrefixes=" + this.blobPrefixes + ", delimiter=" + this.delimiter + "]";
    }
}

