/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public final class BindPublicAccessToRequest
implements Binder {
    @Inject
    public BindPublicAccessToRequest() {
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkNotNull(request, (Object)"request");
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof PublicAccess), (Object)"this binder is only valid for PublicAccess");
        PublicAccess access = (PublicAccess)((Object)input);
        switch (access) {
            case PRIVATE: {
                break;
            }
            default: {
                request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-ms-blob-public-access", new String[]{access.name().toLowerCase()})).build();
            }
        }
        return request;
    }
}

