/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.blobstore.functions.BlobToAzureBlob;
import org.jclouds.azureblob.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.azureblob.blobstore.functions.ListBlobsResponseToResourceList;
import org.jclouds.azureblob.blobstore.functions.ListOptionsToListBlobsOptions;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobBlockProperties;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobBlocksResponse;
import org.jclouds.azureblob.domain.ListBlobsInclude;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CopyBlobOptions;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;

@Singleton
public class AzureBlobStore
extends BaseBlobStore {
    private final AzureBlobClient sync;
    private final ContainerToResourceMetadata container2ResourceMd;
    private final ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions;
    private final ListBlobsResponseToResourceList azure2BlobStoreResourceList;
    private final AzureBlobToBlob azureBlob2Blob;
    private final BlobToAzureBlob blob2AzureBlob;
    private final BlobPropertiesToBlobMetadata blob2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;

    @Inject
    AzureBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, AzureBlobClient sync, ContainerToResourceMetadata container2ResourceMd, ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions, ListBlobsResponseToResourceList azure2BlobStoreResourceList, AzureBlobToBlob azureBlob2Blob, BlobToAzureBlob blob2AzureBlob, BlobPropertiesToBlobMetadata blob2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions) {
        super(context, blobUtils, defaultLocation, locations, slicer);
        this.sync = (AzureBlobClient)Preconditions.checkNotNull((Object)sync, (Object)"sync");
        this.container2ResourceMd = (ContainerToResourceMetadata)Preconditions.checkNotNull((Object)container2ResourceMd, (Object)"container2ResourceMd");
        this.blobStore2AzureContainerListOptions = (ListOptionsToListBlobsOptions)Preconditions.checkNotNull((Object)blobStore2AzureContainerListOptions, (Object)"blobStore2AzureContainerListOptions");
        this.azure2BlobStoreResourceList = (ListBlobsResponseToResourceList)Preconditions.checkNotNull((Object)azure2BlobStoreResourceList, (Object)"azure2BlobStoreResourceList");
        this.azureBlob2Blob = (AzureBlobToBlob)Preconditions.checkNotNull((Object)azureBlob2Blob, (Object)"azureBlob2Blob");
        this.blob2AzureBlob = (BlobToAzureBlob)Preconditions.checkNotNull((Object)blob2AzureBlob, (Object)"blob2AzureBlob");
        this.blob2BlobMd = (BlobPropertiesToBlobMetadata)Preconditions.checkNotNull((Object)blob2BlobMd, (Object)"blob2BlobMd");
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
    }

    public PageSet<? extends StorageMetadata> list() {
        return new Function<BoundedSet<ContainerProperties>, PageSet<? extends StorageMetadata>>(){

            public PageSet<? extends StorageMetadata> apply(BoundedSet<ContainerProperties> from) {
                return new PageSetImpl(Iterables.transform(from, (Function)AzureBlobStore.this.container2ResourceMd), from.getNextMarker());
            }
        }.apply(this.sync.listContainers(ListOptions.Builder.includeMetadata()));
    }

    public boolean containerExists(String container) {
        return this.sync.containerExists(container);
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.sync.createContainer(container, new CreateContainerOptions[0]);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        ListBlobsOptions azureOptions = this.blobStore2AzureContainerListOptions.apply(options);
        return this.azure2BlobStoreResourceList.apply(this.sync.listBlobs(container, azureOptions.includeMetadata()));
    }

    public void deleteContainer(String container) {
        this.sync.deleteContainer(container);
    }

    public boolean blobExists(String container, String key) {
        return this.sync.blobExists(container, key);
    }

    public Blob getBlob(String container, String key, GetOptions options) {
        org.jclouds.http.options.GetOptions azureOptions = this.blob2ObjectGetOptions.apply(options);
        return this.azureBlob2Blob.apply(this.sync.getBlob(container, key, azureOptions));
    }

    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, new PutOptions());
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        if (options.getBlobAccess() != BlobAccess.PRIVATE) {
            throw new UnsupportedOperationException("blob access not supported by Azure");
        }
        String eTag = options.isMultipart() ? this.putMultipartBlob(container, blob, options) : this.sync.putBlob(container, this.blob2AzureBlob.apply(blob));
        Tier tier = blob.getMetadata().getTier();
        if (tier != Tier.STANDARD) {
            this.sync.setBlobTier(container, blob.getMetadata().getName(), AccessTier.fromTier(tier));
        }
        return eTag;
    }

    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        Map userMetadata;
        CopyBlobOptions.Builder azureOptions = CopyBlobOptions.builder();
        if (options.ifMatch() != null) {
            azureOptions.ifMatch(options.ifMatch());
        }
        if (options.ifNoneMatch() != null) {
            azureOptions.ifNoneMatch(options.ifNoneMatch());
        }
        if (options.ifModifiedSince() != null) {
            azureOptions.ifModifiedSince(options.ifModifiedSince());
        }
        if (options.ifUnmodifiedSince() != null) {
            azureOptions.ifUnmodifiedSince(options.ifUnmodifiedSince());
        }
        if ((userMetadata = options.userMetadata()) != null) {
            azureOptions.overrideUserMetadata(userMetadata);
        }
        URI source = this.context.getSigner().signGetBlob(fromContainer, fromName).getEndpoint();
        String eTag = this.sync.copyBlob(source, toContainer, toName, azureOptions.build());
        ContentMetadata contentMetadata = options.contentMetadata();
        if (contentMetadata != null) {
            String contentType;
            String contentLanguage;
            String contentEncoding;
            String contentDisposition;
            ContentMetadataBuilder builder = ContentMetadataBuilder.create();
            String cacheControl = contentMetadata.getCacheControl();
            if (cacheControl != null) {
                builder.cacheControl(cacheControl);
            }
            if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
                builder.contentDisposition(contentDisposition);
            }
            if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                builder.contentEncoding(contentEncoding);
            }
            if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                builder.contentLanguage(contentLanguage);
            }
            if ((contentType = contentMetadata.getContentType()) != null) {
                builder.contentType(contentType);
            }
            eTag = this.sync.setBlobProperties(toContainer, toName, builder.build());
        }
        return eTag;
    }

    public void removeBlob(String container, String key) {
        this.sync.deleteBlob(container, key);
    }

    public void putBlock(String container, String name, String blockId, Payload block) {
        this.sync.putBlock(container, name, blockId, block);
    }

    public String putBlockList(String container, String name, List<String> blockIdList) {
        return this.sync.putBlockList(container, name, blockIdList);
    }

    public ListBlobBlocksResponse getBlockList(String container, String name) {
        return this.sync.getBlockList(container, name);
    }

    public BlobMetadata blobMetadata(String container, String key) {
        return this.blob2BlobMd.apply(this.sync.getBlobProperties(container, key));
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        if (!this.list(container).isEmpty()) {
            return false;
        }
        this.sync.deleteContainer(container);
        return true;
    }

    public boolean createContainerInLocation(Location location, String container, org.jclouds.blobstore.options.CreateContainerOptions options) {
        CreateContainerOptions createContainerOptions = new CreateContainerOptions();
        if (options.isPublicRead()) {
            createContainerOptions.withPublicAccess(PublicAccess.CONTAINER);
        }
        return this.sync.createContainer(container, createContainerOptions);
    }

    public ContainerAccess getContainerAccess(String container) {
        PublicAccess access = this.sync.getPublicAccessForContainer(container);
        if (access == PublicAccess.CONTAINER) {
            return ContainerAccess.PUBLIC_READ;
        }
        return ContainerAccess.PRIVATE;
    }

    public void setContainerAccess(String container, ContainerAccess access) {
        PublicAccess publicAccess = access == ContainerAccess.PUBLIC_READ ? PublicAccess.CONTAINER : PublicAccess.PRIVATE;
        this.sync.setPublicAccessForContainer(container, publicAccess);
    }

    public BlobAccess getBlobAccess(String container, String key) {
        return BlobAccess.PRIVATE;
    }

    public void setBlobAccess(String container, String key, BlobAccess access) {
        throw new UnsupportedOperationException("unsupported in Azure");
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        String uploadId = UUID.randomUUID().toString();
        return MultipartUpload.create((String)container, (String)blobMetadata.getName(), (String)uploadId, (BlobMetadata)blobMetadata, (PutOptions)options);
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        AzureBlob azureBlob = this.sync.newBlob();
        azureBlob.setPayload(new byte[0]);
        azureBlob.getProperties().setContainer(mpu.containerName());
        azureBlob.getProperties().setName(mpu.blobName());
        azureBlob.getProperties().setContentMetadata((MutableContentMetadata)mpu.blobMetadata().getContentMetadata());
        azureBlob.getProperties().setMetadata(mpu.blobMetadata().getUserMetadata());
        ImmutableList.Builder blocks = ImmutableList.builder();
        for (MultipartPart part : parts) {
            String blockId = AzureBlobStore.makeBlockId(part.partNumber());
            blocks.add((Object)blockId);
        }
        return this.sync.putBlockList(mpu.containerName(), azureBlob, (List<String>)blocks.build());
    }

    static String makeBlockId(int partNumber) {
        return BaseEncoding.base64Url().encode(Ints.toByteArray((int)partNumber));
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        String blockId = AzureBlobStore.makeBlockId(partNumber);
        this.sync.putBlock(mpu.containerName(), mpu.blobName(), blockId, payload);
        String eTag = "";
        Object lastModified = null;
        return MultipartPart.create((int)partNumber, (long)payload.getContentMetadata().getContentLength(), (String)eTag);
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        ListBlobBlocksResponse response;
        try {
            response = this.sync.getBlockList(mpu.containerName(), mpu.blobName());
        }
        catch (KeyNotFoundException knfe) {
            return ImmutableList.of();
        }
        ImmutableList.Builder parts = ImmutableList.builder();
        for (BlobBlockProperties properties : response.getBlocks()) {
            int partNumber = Ints.fromByteArray((byte[])BaseEncoding.base64().decode((CharSequence)properties.getBlockName()));
            String eTag = "";
            Date lastModified = null;
            parts.add((Object)MultipartPart.create((int)partNumber, (long)properties.getContentLength(), (String)eTag, lastModified));
        }
        return parts.build();
    }

    public List<MultipartUpload> listMultipartUploads(String container) {
        ListBlobsResponse response;
        ImmutableList.Builder builder = ImmutableList.builder();
        String marker = null;
        do {
            ListBlobsOptions options = new ListBlobsOptions().include(EnumSet.of(ListBlobsInclude.UNCOMMITTEDBLOBS));
            if (marker != null) {
                options.marker(marker);
            }
            response = this.sync.listBlobs(container, options);
            for (BlobProperties properties : response) {
                if (properties.getETag() != null) continue;
                String uploadId = UUID.randomUUID().toString();
                builder.add((Object)MultipartUpload.create((String)properties.getContainer(), (String)properties.getName(), (String)uploadId, null, null));
            }
        } while ((marker = response.getNextMarker()) != null);
        return builder.build();
    }

    public long getMinimumMultipartPartSize() {
        return 1L;
    }

    public long getMaximumMultipartPartSize() {
        return 0x6400000L;
    }

    public int getMaximumNumberOfParts() {
        return 50000;
    }

    public InputStream streamBlob(String container, String name) {
        throw new UnsupportedOperationException("Azure does not support streaming a blob");
    }
}

