/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.functions;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import org.jclouds.b2.domain.B2Object;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;

public final class ParseB2ObjectFromResponse
implements Function<HttpResponse, B2Object> {
    public B2Object apply(HttpResponse from) {
        String fileName;
        Payload payload = from.getPayload();
        MutableContentMetadata contentMeta = payload.getContentMetadata();
        String fileId = from.getFirstHeaderOrNull("X-Bz-File-Id");
        try {
            fileName = URLDecoder.decode(from.getFirstHeaderOrNull("X-Bz-File-Name"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw Throwables.propagate((Throwable)uee);
        }
        String contentSha1 = from.getFirstHeaderOrNull("X-Bz-Content-Sha1");
        ImmutableMap.Builder fileInfo = ImmutableMap.builder();
        for (Map.Entry entry : from.getHeaders().entries()) {
            String value;
            if (!((String)entry.getKey()).regionMatches(true, 0, "X-Bz-Info-", 0, "X-Bz-Info-".length())) continue;
            try {
                value = URLDecoder.decode((String)entry.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw Throwables.propagate((Throwable)uee);
            }
            fileInfo.put((Object)((String)entry.getKey()).substring("X-Bz-Info-".length()), (Object)value);
        }
        Date uploadTimestamp = new Date(Long.parseLong(from.getFirstHeaderOrNull("X-Bz-Upload-Timestamp")));
        String contentRange = from.getFirstHeaderOrNull("Content-Range");
        return B2Object.create(fileId, fileName, null, null, contentMeta.getContentLength(), contentSha1, contentMeta.getContentType(), (Map<String, String>)fileInfo.build(), null, uploadTimestamp.getTime(), contentRange, payload);
    }
}

