/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma;

import java.io.Closeable;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.cloudsigma.binders.BindCloneDriveOptionsToPlainTextString;
import org.jclouds.cloudsigma.binders.BindDriveDataToPlainTextString;
import org.jclouds.cloudsigma.binders.BindDriveToPlainTextString;
import org.jclouds.cloudsigma.binders.BindServerToPlainTextString;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.cloudsigma.domain.ProfileInfo;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.domain.ServerInfo;
import org.jclouds.cloudsigma.domain.StaticIPInfo;
import org.jclouds.cloudsigma.domain.VLANInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToDriveInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToProfileInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToServerInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToStaticIPInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToVLANInfo;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToStaticIPInfoSet;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToVLANInfoSet;
import org.jclouds.cloudsigma.functions.SplitNewlines;
import org.jclouds.cloudsigma.functions.SplitNewlinesAndReturnSecondField;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={BasicAuthentication.class})
@Consumes(value={"text/plain"})
public interface CloudSigmaApi
extends Closeable {
    @GET
    @Path(value="/drives/standard/list")
    @ResponseParser(value=SplitNewlines.class)
    public Set<String> listStandardDrives();

    @GET
    @Path(value="/drives/standard/cd/list")
    @ResponseParser(value=SplitNewlines.class)
    public Set<String> listStandardCds();

    @GET
    @Path(value="/drives/standard/img/list")
    @ResponseParser(value=SplitNewlines.class)
    public Set<String> listStandardImages();

    @POST
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToDriveInfo.class)
    @Path(value="/drives/{uuid}/clone")
    @MapBinder(value=BindCloneDriveOptionsToPlainTextString.class)
    public DriveInfo cloneDrive(@PathParam(value="uuid") String var1, @PayloadParam(value="name") String var2, CloneDriveOptions ... var3);

    @GET
    @Path(value="/profile/info")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToProfileInfo.class)
    public ProfileInfo getProfileInfo();

    @GET
    @Path(value="/drives/info")
    @ResponseParser(value=ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet.class)
    public Set<DriveInfo> listDriveInfo();

    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToDriveInfo.class)
    @Path(value="/drives/{uuid}/info")
    public DriveInfo getDriveInfo(@PathParam(value="uuid") String var1);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToDriveInfo.class)
    @Path(value="/drives/create")
    public DriveInfo createDrive(@BinderParam(value=BindDriveToPlainTextString.class) Drive var1);

    @POST
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToDriveInfo.class)
    @Path(value="/drives/{uuid}/set")
    public DriveInfo setDriveData(@PathParam(value="uuid") String var1, @BinderParam(value=BindDriveDataToPlainTextString.class) DriveData var2);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToServerInfo.class)
    @Path(value="/servers/create")
    public ServerInfo createServer(@BinderParam(value=BindServerToPlainTextString.class) Server var1);

    @GET
    @Path(value="/servers/info")
    @ResponseParser(value=ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet.class)
    public Set<ServerInfo> listServerInfo();

    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToServerInfo.class)
    @Path(value="/servers/{uuid}/info")
    public ServerInfo getServerInfo(@PathParam(value="uuid") String var1);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToServerInfo.class)
    @Path(value="/servers/{uuid}/set")
    public ServerInfo setServerConfiguration(@PathParam(value="uuid") String var1, @BinderParam(value=BindServerToPlainTextString.class) Server var2);

    @GET
    @Path(value="/servers/list")
    @ResponseParser(value=SplitNewlines.class)
    public Set<String> listServers();

    @GET
    @Path(value="/servers/{uuid}/destroy")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void destroyServer(@PathParam(value="uuid") String var1);

    @POST
    @Path(value="/servers/{uuid}/start")
    public void startServer(@PathParam(value="uuid") String var1);

    @POST
    @Path(value="/servers/{uuid}/stop")
    public void stopServer(@PathParam(value="uuid") String var1);

    @POST
    @Path(value="/servers/{uuid}/shutdown")
    public void shutdownServer(@PathParam(value="uuid") String var1);

    @POST
    @Path(value="/servers/{uuid}/reset")
    public void resetServer(@PathParam(value="uuid") String var1);

    @GET
    @Path(value="/drives/list")
    @ResponseParser(value=SplitNewlines.class)
    public Set<String> listDrives();

    @GET
    @Path(value="/drives/{uuid}/destroy")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void destroyDrive(@PathParam(value="uuid") String var1);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToVLANInfo.class)
    @Path(value="/resources/vlan/create")
    @Payload(value="name {name}\n")
    @Produces(value={"text/plain"})
    public VLANInfo createVLAN(@PayloadParam(value="name") String var1);

    @GET
    @Path(value="/resources/vlan/info")
    @ResponseParser(value=ListOfKeyValuesDelimitedByBlankLinesToVLANInfoSet.class)
    public Set<VLANInfo> listVLANInfo();

    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToVLANInfo.class)
    @Path(value="/resources/vlan/{uuid}/info")
    public VLANInfo getVLANInfo(@PathParam(value="uuid") String var1);

    @POST
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToVLANInfo.class)
    @Path(value="/resources/vlan/{uuid}/set")
    @Payload(value="name {name}\n")
    @Produces(value={"text/plain"})
    public VLANInfo renameVLAN(@PathParam(value="uuid") String var1, @PayloadParam(value="name") String var2);

    @GET
    @Path(value="/resources/vlan/list")
    @ResponseParser(value=SplitNewlinesAndReturnSecondField.class)
    public Set<String> listVLANs();

    @GET
    @Path(value="/resources/vlan/{uuid}/destroy")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void destroyVLAN(@PathParam(value="uuid") String var1);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToStaticIPInfo.class)
    @Path(value="/resources/ip/create")
    public StaticIPInfo createStaticIP();

    @GET
    @Path(value="/resources/ip/info")
    @ResponseParser(value=ListOfKeyValuesDelimitedByBlankLinesToStaticIPInfoSet.class)
    public Set<StaticIPInfo> listStaticIPInfo();

    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToStaticIPInfo.class)
    @Path(value="/resources/ip/{uuid}/info")
    public StaticIPInfo getStaticIPInfo(@PathParam(value="uuid") String var1);

    @GET
    @Path(value="/resources/ip/list")
    @ResponseParser(value=SplitNewlinesAndReturnSecondField.class)
    public Set<String> listStaticIPs();

    @GET
    @Path(value="/resources/ip/{uuid}/destroy")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void destroyStaticIP(@PathParam(value="uuid") String var1);
}

