/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Binder;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jclouds.concurrent.SingleThreaded;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.features.SessionApi;
import org.jclouds.dynect.v3.filters.SessionManager;
import org.jclouds.dynect.v3.handlers.DynECTErrorHandler;
import org.jclouds.dynect.v3.handlers.GetJobRedirectionRetryHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.handlers.RedirectionRetryHandler;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.http.internal.JavaUrlHttpCommandExecutorService;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
@SingleThreaded
public class DynECTHttpApiModule
extends HttpApiModule<DynECTApi> {
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(DynECTErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(DynECTErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(DynECTErrorHandler.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(SessionManager.class);
    }

    protected void configure() {
        this.bind(SessionManager.class);
        this.bind(RedirectionRetryHandler.class).to(GetJobRedirectionRetryHandler.class);
        super.configure();
        BinderUtils.bindHttpApi((Binder)this.binder(), SessionApi.class);
        this.bind(JavaUrlHttpCommandExecutorService.class).to(SillyRabbit200sAreForSuccess.class);
    }

    @Singleton
    private static class SillyRabbit200sAreForSuccess
    extends JavaUrlHttpCommandExecutorService {
        @Inject
        private SillyRabbit200sAreForSuccess(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, @Named(value="jclouds.io-worker-threads") ListeningExecutorService ioExecutor, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, Function<URI, Proxy> proxyForURI) throws SecurityException, NoSuchFieldException {
            super(utils, contentMetadataCodec, ioExecutor, retryHandler, ioRetryHandler, errorHandler, wire, verifier, untrustedSSLContextProvider, proxyForURI);
        }

        protected synchronized HttpResponse invoke(HttpURLConnection connection) throws IOException, InterruptedException {
            HttpResponse response = super.invoke(connection);
            if (response.getStatusCode() == 200) {
                String message;
                byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
                String string = message = data != null ? new String(data, "UTF-8") : null;
                if (message != null && !message.startsWith("{\"status\": \"success\"")) {
                    response = response.toBuilder().statusCode(400).build();
                }
            }
            return response;
        }
    }
}

