/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.domain.Credentials;

public final class SessionCredentials
extends Credentials {
    @Named(value="customer_name")
    private final String customerName;
    @Named(value="user_name")
    private final String userName;
    private final String password;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SessionCredentials.builder().from(this);
    }

    @ConstructorProperties(value={"customer_name", "user_name", "password"})
    private SessionCredentials(String customerName, String userName, String password) {
        super((String)Preconditions.checkNotNull((Object)userName, (Object)"userName"), (String)Preconditions.checkNotNull((Object)password, (String)"password for %s", (Object[])new Object[]{userName}));
        this.userName = userName;
        this.password = password;
        this.customerName = (String)Preconditions.checkNotNull((Object)customerName, (String)"customerName for %s", (Object[])new Object[]{userName});
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.customerName, this.userName, this.password});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SessionCredentials other = (SessionCredentials)((Object)SessionCredentials.class.cast(obj));
        return Objects.equal((Object)this.userName, (Object)other.userName) && Objects.equal((Object)this.password, (Object)other.password) && Objects.equal((Object)this.customerName, (Object)other.customerName);
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("userName", (Object)this.identity).add("customerName", (Object)this.customerName).toString();
    }

    public static final class Builder
    extends Credentials.Builder<SessionCredentials> {
        private String customerName;
        private String userName;
        private String password;

        public Builder customerName(String customerName) {
            this.customerName = customerName;
            return this;
        }

        public Builder identity(String identity) {
            return this.userName(identity);
        }

        public Builder credential(String credential) {
            return this.password(credential);
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public SessionCredentials build() {
            return new SessionCredentials(this.customerName, this.userName, this.password);
        }

        public Builder from(SessionCredentials in) {
            return this.userName(in.identity).password(in.credential).customerName(in.customerName);
        }
    }
}

