/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.filters;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.jclouds.domain.Credentials;
import org.jclouds.dynect.v3.domain.Session;
import org.jclouds.dynect.v3.domain.SessionCredentials;
import org.jclouds.dynect.v3.features.SessionApi;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

@Singleton
public final class SessionManager
extends BackoffLimitedRetryHandler
implements HttpRequestFilter {
    @Resource
    private Logger logger = Logger.NULL;
    private final Supplier<Credentials> creds;
    private final SessionApi sessionApi;
    private final LoadingCache<Credentials, Session> sessionCache;
    private static final String IP_MISMATCH = "IP address does not match current session";

    @Inject
    SessionManager(@Provider Supplier<Credentials> creds, SessionApi sessionApi) {
        this(creds, SessionManager.buildCache(sessionApi), sessionApi);
    }

    SessionManager(@Provider Supplier<Credentials> creds, LoadingCache<Credentials, Session> sessionCache, SessionApi sessionApi) {
        this.creds = creds;
        this.sessionCache = sessionCache;
        this.sessionApi = sessionApi;
    }

    static LoadingCache<Credentials, Session> buildCache(final SessionApi sessionApi) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Credentials, Session>(){

            public Session load(Credentials key) {
                return sessionApi.login(SessionManager.convert(key));
            }
        });
    }

    static SessionCredentials convert(Credentials key) {
        if (key instanceof SessionCredentials) {
            return (SessionCredentials)((Object)SessionCredentials.class.cast(key));
        }
        return SessionCredentials.builder().customerName(key.identity.substring(0, key.identity.indexOf(58))).userName(key.identity.substring(key.identity.indexOf(58) + 1)).password(key.credential).build();
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Session session = (Session)this.sessionCache.getUnchecked(this.creds.get());
        HttpRequest.Builder builder = request.toBuilder();
        builder.replaceHeader("Auth-Token", new String[]{session.getToken()});
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        boolean retry = false;
        try {
            String message;
            byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
            String string = message = data != null ? new String(data) : null;
            if (response.getStatusCode() == 401 || message != null && message.indexOf(IP_MISMATCH) != -1) {
                this.logger.debug("invalidating session", new Object[0]);
                this.sessionCache.invalidateAll();
                retry = super.shouldRetryRequest(command, response);
            }
            boolean bl = retry;
            return bl;
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
        }
    }

    @PreDestroy
    public void logoutOnClose() {
        for (Session s : this.sessionCache.asMap().values()) {
            try {
                this.sessionApi.logout(s.getToken());
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "error logging out session %s", new Object[]{s});
            }
        }
    }
}

