/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;

@Beta
public class EmailOverviewSummary {
    private final int accounts;
    private final int maxAccounts;
    private final int aliases;
    private final int maxAliases;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromEmailOverviewSummary(this);
    }

    @ConstructorProperties(value={"accounts", "maxaccounts", "aliases", "maxaliases"})
    protected EmailOverviewSummary(int accounts, int maxAccounts, int aliases, int maxAliases) {
        this.accounts = accounts;
        this.maxAccounts = maxAccounts;
        this.aliases = aliases;
        this.maxAliases = maxAliases;
    }

    public int getAccounts() {
        return this.accounts;
    }

    public int getMaxAccounts() {
        return this.maxAccounts;
    }

    public int getAliases() {
        return this.aliases;
    }

    public int getMaxAliases() {
        return this.maxAliases;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accounts, this.maxAccounts, this.aliases, this.maxAliases});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EmailOverviewSummary that = (EmailOverviewSummary)EmailOverviewSummary.class.cast(obj);
        return Objects.equal((Object)this.accounts, (Object)that.accounts) && Objects.equal((Object)this.maxAccounts, (Object)that.maxAccounts) && Objects.equal((Object)this.aliases, (Object)that.aliases) && Objects.equal((Object)this.maxAliases, (Object)that.maxAliases);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("accounts", this.accounts).add("maxAccounts", this.maxAccounts).add("aliases", this.aliases).add("maxAliases", this.maxAliases);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int accounts;
        protected int maxAccounts;
        protected int aliases;
        protected int maxAliases;

        protected abstract T self();

        public T accounts(int accounts) {
            this.accounts = accounts;
            return this.self();
        }

        public T maxAccounts(int maxAccounts) {
            this.maxAccounts = maxAccounts;
            return this.self();
        }

        public T aliases(int aliases) {
            this.aliases = aliases;
            return this.self();
        }

        public T maxAliases(int maxAliases) {
            this.maxAliases = maxAliases;
            return this.self();
        }

        public EmailOverviewSummary build() {
            return new EmailOverviewSummary(this.accounts, this.maxAccounts, this.aliases, this.maxAliases);
        }

        public T fromEmailOverviewSummary(EmailOverviewSummary in) {
            return ((Builder)((Builder)((Builder)this.accounts(in.getAccounts())).maxAccounts(in.getMaxAccounts())).aliases(in.getAliases())).maxAliases(in.getMaxAliases());
        }
    }
}

