/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class ResourceStatus {
    private final double usage;
    private final double max;
    private final String unit;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromResourceUsage(this);
    }

    @ConstructorProperties(value={"usage", "max", "unit"})
    protected ResourceStatus(double usage, double max, String unit) {
        this.usage = usage;
        this.max = max;
        this.unit = (String)Preconditions.checkNotNull((Object)unit, (Object)"unit");
    }

    public double getUsage() {
        return this.usage;
    }

    public double getMax() {
        return this.max;
    }

    public String getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.usage, this.max, this.unit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceStatus that = (ResourceStatus)ResourceStatus.class.cast(obj);
        return Objects.equal((Object)this.usage, (Object)that.usage) && Objects.equal((Object)this.max, (Object)that.max) && Objects.equal((Object)this.unit, (Object)that.unit);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("usage", this.usage).add("max", this.max).add("unit", (Object)this.unit);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected double usage;
        protected double max;
        protected String unit;

        protected abstract T self();

        public T usage(double usage) {
            this.usage = usage;
            return this.self();
        }

        public T max(double max) {
            this.max = max;
            return this.self();
        }

        public T unit(String unit) {
            this.unit = (String)Preconditions.checkNotNull((Object)unit, (Object)"unit");
            return this.self();
        }

        public ResourceStatus build() {
            return new ResourceStatus(this.usage, this.max, this.unit);
        }

        public T fromResourceUsage(ResourceStatus in) {
            return ((Builder)((Builder)this.usage(in.getUsage())).max(in.getMax())).unit(in.getUnit());
        }
    }
}

