/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Server {
    private final String id;
    private final String hostname;
    private final String datacenter;
    private final String platform;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServer(this);
    }

    @ConstructorProperties(value={"serverid", "hostname", "datacenter", "platform"})
    protected Server(String id, String hostname, String datacenter, String platform) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname");
        this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
        this.platform = (String)Preconditions.checkNotNull((Object)platform, (Object)"platform");
    }

    public String getId() {
        return this.id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getPlatform() {
        return this.platform;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Server that = (Server)Server.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("hostname", (Object)this.hostname).add("datacenter", (Object)this.datacenter).add("platform", (Object)this.platform);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String hostname;
        protected String datacenter;
        protected String platform;

        protected abstract T self();

        public T id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this.self();
        }

        public T hostname(String hostname) {
            this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname");
            return this.self();
        }

        public T datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            return this.self();
        }

        public T platform(String platform) {
            this.platform = (String)Preconditions.checkNotNull((Object)platform, (Object)"platform");
            return this.self();
        }

        public Server build() {
            return new Server(this.id, this.hostname, this.datacenter, this.platform);
        }

        public T fromServer(Server in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).hostname(in.getHostname())).datacenter(in.getDatacenter())).platform(in.getPlatform());
        }
    }

    public static enum State {
        RUNNING,
        LOCKED,
        STOPPED,
        UNRECOGNIZED;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

