/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.glesys.domain.IpDetails;
import org.jclouds.glesys.options.ListIpOptions;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={BasicAuthentication.class})
public interface IpAsyncApi {
    @Named(value="ip:listfree")
    @GET
    @Path(value="/ip/listfree/ipversion/{ipversion}/datacenter/{datacenter}/platform/{platform}/format/json")
    @Consumes(value={"application/json"})
    @SelectJson(value={"ipaddresses"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<FluentIterable<String>> listFree(@PathParam(value="ipversion") int var1, @PathParam(value="datacenter") String var2, @PathParam(value="platform") String var3);

    @Named(value="ip:take")
    @POST
    @Path(value="/ip/take/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public ListenableFuture<IpDetails> take(@FormParam(value="ipaddress") String var1);

    @Named(value="ip:release")
    @POST
    @Path(value="/ip/release/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public ListenableFuture<IpDetails> release(@FormParam(value="ipaddress") String var1);

    @Named(value="ip:listown")
    @GET
    @Path(value="/ip/listown/format/json")
    @Consumes(value={"application/json"})
    @SelectJson(value={"iplist"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<FluentIterable<IpDetails>> list(ListIpOptions ... var1);

    @Named(value="ip:details")
    @GET
    @Path(value="/ip/details/ipaddress/{ipaddress}/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<IpDetails> get(@PathParam(value="ipaddress") String var1);

    @Named(value="ip:add")
    @POST
    @Path(value="/ip/add/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public ListenableFuture<IpDetails> addToServer(@FormParam(value="ipaddress") String var1, @FormParam(value="serverid") String var2);

    @Named(value="ip:remove")
    @POST
    @Path(value="/ip/remove/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public ListenableFuture<IpDetails> removeFromServer(@FormParam(value="ipaddress") String var1, @FormParam(value="serverid") String var2);

    @Named(value="ip:remove:release")
    @POST
    @FormParams(keys={"release"}, values={"true"})
    @Path(value="/ip/remove/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public ListenableFuture<IpDetails> removeFromServerAndRelease(@FormParam(value="ipaddress") String var1, @FormParam(value="serverid") String var2);

    @Named(value="ip:setptr")
    @POST
    @Path(value="/ip/setptr/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public ListenableFuture<IpDetails> setPtr(@FormParam(value="ipaddress") String var1, @FormParam(value="data") String var2);

    @Named(value="ip:resetptr")
    @POST
    @Path(value="/ip/resetptr/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public ListenableFuture<IpDetails> resetPtr(@FormParam(value="ipaddress") String var1);
}

