/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.glesys.domain.ServerSpec;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.UrlEncodedFormPayload;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class CreateServerOptions
implements MapBinder {
    private String ip;
    private String description;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        ImmutableMultimap.Builder formParams = ImmutableMultimap.builder();
        for (Map.Entry<String, Object> entry : postParams.entrySet()) {
            formParams.put((Object)entry.getKey(), (Object)((String)entry.getValue()));
        }
        ServerSpec serverSpec = (ServerSpec)ServerSpec.class.cast(Iterables.find((Iterable)gRequest.getInvocation().getArgs(), (Predicate)Predicates.instanceOf(ServerSpec.class)));
        formParams.put((Object)"datacenter", (Object)serverSpec.getDatacenter());
        formParams.put((Object)"platform", (Object)serverSpec.getPlatform());
        formParams.put((Object)"templatename", (Object)serverSpec.getTemplateName());
        formParams.put((Object)"disksize", (Object)(serverSpec.getDiskSizeGB() + ""));
        formParams.put((Object)"memorysize", (Object)(serverSpec.getMemorySizeMB() + ""));
        formParams.put((Object)"cpucores", (Object)(serverSpec.getCpuCores() + ""));
        formParams.put((Object)"transfer", (Object)(serverSpec.getTransferGB() + ""));
        if (this.ip != null) {
            formParams.put((Object)"ip", (Object)this.ip);
        }
        if (this.description != null) {
            formParams.put((Object)"description", (Object)this.description);
        }
        request.setPayload((Payload)new UrlEncodedFormPayload((Multimap)formParams.build()));
        return request;
    }

    public CreateServerOptions description(String description) {
        this.description = description;
        return this;
    }

    public CreateServerOptions ip(String ip) {
        this.ip = ip;
        return this;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ip, this.description});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerOptions)) {
            return false;
        }
        CreateServerOptions that = (CreateServerOptions)CreateServerOptions.class.cast(obj);
        return Objects.equal((Object)this.ip, (Object)that.ip) && Objects.equal((Object)this.description, (Object)that.description);
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("ip", (Object)this.ip).add("description", (Object)this.description).toString();
    }

    public static class Builder {
        public static CreateServerOptions description(String primaryNameServer) {
            CreateServerOptions options = new CreateServerOptions();
            return options.description(primaryNameServer);
        }

        public static CreateServerOptions ip(String ip) {
            CreateServerOptions options = new CreateServerOptions();
            return options.ip(ip);
        }
    }
}

