/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.LoadBalancerOs;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerState;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.javax.annotation.Nullable;

public class LoadBalancer
implements Comparable<LoadBalancer> {
    private final long id;
    private final String name;
    private final String description;
    private final IpPortPair virtualIp;
    private final Set<IpPortPair> realIpList;
    private final LoadBalancerType type;
    private final LoadBalancerPersistenceType persistence;
    private final LoadBalancerOs os;
    private final LoadBalancerState state;
    private final Option datacenter;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromLoadBalancer(this);
    }

    @ConstructorProperties(value={"id", "name", "description", "virtualip", "realiplist", "type", "persistence", "os", "state", "datacenter"})
    protected LoadBalancer(long id, String name, @Nullable String description, IpPortPair virtualIp, Set<IpPortPair> realIpList, LoadBalancerType type, LoadBalancerPersistenceType persistence, LoadBalancerOs os, LoadBalancerState state, Option datacenter) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = description;
        this.virtualIp = (IpPortPair)Preconditions.checkNotNull((Object)virtualIp, (Object)"virtualIp");
        this.realIpList = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(realIpList, (Object)"realIpList")));
        this.type = (LoadBalancerType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.persistence = (LoadBalancerPersistenceType)((Object)Preconditions.checkNotNull((Object)((Object)persistence), (Object)"persistence"));
        this.os = (LoadBalancerOs)((Object)Preconditions.checkNotNull((Object)((Object)os), (Object)"os"));
        this.state = (LoadBalancerState)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        this.datacenter = (Option)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public IpPortPair getVirtualIp() {
        return this.virtualIp;
    }

    public Set<IpPortPair> getRealIpList() {
        return this.realIpList;
    }

    public LoadBalancerType getType() {
        return this.type;
    }

    public LoadBalancerPersistenceType getPersistence() {
        return this.persistence;
    }

    public LoadBalancerOs getOs() {
        return this.os;
    }

    public LoadBalancerState getState() {
        return this.state;
    }

    public Option getDatacenter() {
        return this.datacenter;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.description, this.virtualIp, this.realIpList, this.type, this.persistence, this.os, this.state, this.datacenter});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancer that = (LoadBalancer)LoadBalancer.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.virtualIp, (Object)that.virtualIp) && Objects.equal(this.realIpList, that.realIpList) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)((Object)this.persistence), (Object)((Object)that.persistence)) && Objects.equal((Object)((Object)this.os), (Object)((Object)that.os)) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.datacenter, (Object)that.datacenter);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("virtualIp", (Object)this.virtualIp).add("realIpList", this.realIpList).add("type", (Object)this.type).add("persistence", (Object)this.persistence).add("os", (Object)this.os).add("state", (Object)this.state).add("datacenter", (Object)this.datacenter);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(LoadBalancer o) {
        return Longs.compare((long)this.id, (long)o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long id;
        protected String name;
        protected String description;
        protected IpPortPair virtualIp;
        protected Set<IpPortPair> realIpList = ImmutableSet.of();
        protected LoadBalancerType type;
        protected LoadBalancerPersistenceType persistence;
        protected LoadBalancerOs os;
        protected LoadBalancerState state;
        protected Option datacenter;

        protected abstract T self();

        public T id(long id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T virtualIp(IpPortPair virtualIp) {
            this.virtualIp = virtualIp;
            return this.self();
        }

        public T realIpList(Set<IpPortPair> realIpList) {
            this.realIpList = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(realIpList, (Object)"realIpList")));
            return this.self();
        }

        public T realIpList(IpPortPair ... in) {
            return this.realIpList((Set<IpPortPair>)ImmutableSet.copyOf((Object[])in));
        }

        public T type(LoadBalancerType type) {
            this.type = type;
            return this.self();
        }

        public T persistence(LoadBalancerPersistenceType persistence) {
            this.persistence = persistence;
            return this.self();
        }

        public T os(LoadBalancerOs os) {
            this.os = os;
            return this.self();
        }

        public T state(LoadBalancerState state) {
            this.state = state;
            return this.self();
        }

        public T datacenter(Option datacenter) {
            this.datacenter = datacenter;
            return this.self();
        }

        public LoadBalancer build() {
            return new LoadBalancer(this.id, this.name, this.description, this.virtualIp, this.realIpList, this.type, this.persistence, this.os, this.state, this.datacenter);
        }

        public T fromLoadBalancer(LoadBalancer in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).description(in.getDescription())).virtualIp(in.getVirtualIp())).realIpList(in.getRealIpList())).type(in.getType())).persistence(in.getPersistence())).os(in.getOs())).state(in.getState())).datacenter(in.getDatacenter());
        }
    }
}

