/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.jclouds.gogrid.binders.BindRealIpPortPairsToQueryParams;
import org.jclouds.gogrid.binders.BindVirtualIpPortPairToQueryParams;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.LoadBalancer;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.filters.SharedKeyLiteAuthentication;
import org.jclouds.gogrid.functions.ParseLoadBalancerFromJsonResponse;
import org.jclouds.gogrid.functions.ParseLoadBalancerListFromJsonResponse;
import org.jclouds.gogrid.functions.ParseOptionsFromJsonResponse;
import org.jclouds.gogrid.options.AddLoadBalancerOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={SharedKeyLiteAuthentication.class})
@QueryParams(keys={"v"}, values={"{jclouds.api-version}"})
public interface GridLoadBalancerAsyncClient {
    @GET
    @ResponseParser(value=ParseLoadBalancerListFromJsonResponse.class)
    @Path(value="/grid/loadbalancer/list")
    public ListenableFuture<Set<LoadBalancer>> getLoadBalancerList();

    @GET
    @ResponseParser(value=ParseLoadBalancerListFromJsonResponse.class)
    @Path(value="/grid/loadbalancer/get")
    public ListenableFuture<Set<LoadBalancer>> getLoadBalancersByName(String ... var1);

    @GET
    @ResponseParser(value=ParseLoadBalancerListFromJsonResponse.class)
    @Path(value="/grid/loadbalancer/get")
    public ListenableFuture<Set<LoadBalancer>> getLoadBalancersById(Long ... var1);

    @GET
    @ResponseParser(value=ParseLoadBalancerFromJsonResponse.class)
    @Path(value="/grid/loadbalancer/add")
    public ListenableFuture<LoadBalancer> addLoadBalancer(@QueryParam(value="name") String var1, @BinderParam(value=BindVirtualIpPortPairToQueryParams.class) IpPortPair var2, @BinderParam(value=BindRealIpPortPairsToQueryParams.class) List<IpPortPair> var3, AddLoadBalancerOptions ... var4);

    @GET
    @ResponseParser(value=ParseLoadBalancerFromJsonResponse.class)
    @Path(value="/grid/loadbalancer/edit")
    public ListenableFuture<LoadBalancer> editLoadBalancerNamed(@QueryParam(value="name") String var1, @BinderParam(value=BindRealIpPortPairsToQueryParams.class) List<IpPortPair> var2);

    @GET
    @ResponseParser(value=ParseLoadBalancerFromJsonResponse.class)
    @Path(value="/grid/loadbalancer/edit")
    public ListenableFuture<LoadBalancer> editLoadBalancer(@QueryParam(value="id") long var1, @BinderParam(value=BindRealIpPortPairsToQueryParams.class) List<IpPortPair> var3);

    @GET
    @ResponseParser(value=ParseLoadBalancerFromJsonResponse.class)
    @Path(value="/grid/loadbalancer/delete")
    public ListenableFuture<LoadBalancer> deleteById(@QueryParam(value="id") Long var1);

    @GET
    @ResponseParser(value=ParseLoadBalancerFromJsonResponse.class)
    @Path(value="/grid/loadbalancer/delete")
    public ListenableFuture<LoadBalancer> deleteByName(@QueryParam(value="name") String var1);

    @GET
    @ResponseParser(value=ParseOptionsFromJsonResponse.class)
    @Path(value="/common/lookup/list")
    @QueryParams(keys={"lookup"}, values={"loadbalancer.datacenter"})
    public ListenableFuture<Set<Option>> getDatacenters();
}

