/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.jclouds.date.TimeStamp;
import org.jclouds.gogrid.GoGridApi;
import org.jclouds.gogrid.config.GoGridParserModule;
import org.jclouds.gogrid.handlers.GoGridErrorHandler;
import org.jclouds.gogrid.location.GoGridDefaultLocationSupplier;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresRestClient
public class GoGridHttpApiModule
extends HttpApiModule<GoGridApi> {
    @Provides
    @TimeStamp
    protected Long provideTimeStamp(@TimeStamp Supplier<Long> cache) {
        return (Long)cache.get();
    }

    @Provides
    @TimeStamp
    Supplier<Long> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Long>(){

            public Long get() {
                return System.currentTimeMillis() / 1000L;
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(GoGridErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(GoGridErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(GoGridErrorHandler.class);
    }

    protected void configure() {
        this.install((Module)new GoGridParserModule());
        super.configure();
    }

    protected void installLocations() {
        super.installLocations();
        this.bind(ImplicitLocationSupplier.class).to(GoGridDefaultLocationSupplier.class).in(Scopes.SINGLETON);
    }
}

