/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import jakarta.inject.Inject;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.googlecloudstorage.domain.Bucket;

public class BucketToStorageMetadata
implements Function<Bucket, StorageMetadata> {
    private Supplier<Location> defaultLocation;

    @Inject
    BucketToStorageMetadata(Supplier<Location> defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    public StorageMetadata apply(Bucket from) {
        MutableStorageMetadataImpl to = new MutableStorageMetadataImpl();
        to.setName(from.name());
        to.setLocation((Location)this.defaultLocation.get());
        to.setType((Enum)StorageType.CONTAINER);
        return to;
    }
}

