/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.jclouds.googlecloud.config.ListPageAdapterFactory;
import org.jclouds.googlecloudstorage.domain.templates.BucketTemplate;
import org.jclouds.json.config.GsonModule;

public class GoogleCloudStorageParserModule
extends AbstractModule {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    @Provides
    @Singleton
    public Map<Type, Object> typeAdapters() {
        return new ImmutableMap.Builder().put(BucketTemplate.class, (Object)new BucketTemplateTypeAdapter()).build();
    }

    @Provides
    @Singleton
    Set<TypeAdapterFactory> typeAdapterFactories() {
        return ImmutableSet.of((Object)new ListPageAdapterFactory());
    }

    private static class BucketTemplateTypeAdapter
    implements JsonSerializer<BucketTemplate> {
        private BucketTemplateTypeAdapter() {
        }

        public JsonElement serialize(BucketTemplate src, Type typeOfSrc, JsonSerializationContext context) {
            BucketTemplateInternal template = new BucketTemplateInternal(src);
            JsonObject bucketTemplate = (JsonObject)context.serialize((Object)template, BucketTemplateInternal.class);
            if (src.acl() != null && src.acl().isEmpty()) {
                bucketTemplate.add("acl", null);
            }
            if (src.defaultObjectAccessControls() != null && src.defaultObjectAccessControls().isEmpty()) {
                bucketTemplate.add("defaultObjectAccessControls", null);
            }
            if (src.cors() != null && src.cors().isEmpty()) {
                bucketTemplate.add("cors", null);
            }
            return bucketTemplate;
        }

        private static class BucketTemplateInternal
        extends BucketTemplate {
            private BucketTemplateInternal(BucketTemplate template) {
                this.name(template.name()).projectNumber(template.projectNumber()).acl(template.acl()).defaultObjectAccessControls(template.defaultObjectAccessControls()).owner(template.owner()).location(template.location()).website(template.website()).logging(template.logging()).versioning(template.versioning()).cors(template.cors()).lifeCycle(template.lifeCycle()).storageClass(template.storageClass());
            }
        }
    }
}

