/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.jclouds.googlecloudstorage.binders.UploadBinder;
import org.jclouds.googlecloudstorage.domain.ResumableUpload;
import org.jclouds.googlecloudstorage.domain.templates.ObjectTemplate;
import org.jclouds.googlecloudstorage.parser.ParseToResumableUpload;
import org.jclouds.io.Payload;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface ResumableUploadApi {
    @Named(value="Object:initResumableUpload")
    @POST
    @QueryParams(keys={"uploadType"}, values={"resumable"})
    @Path(value="/upload/storage/v1/b/{bucket}/o")
    @ResponseParser(value=ParseToResumableUpload.class)
    public ResumableUpload initResumableUpload(@PathParam(value="bucket") String var1, @QueryParam(value="name") String var2, @HeaderParam(value="X-Upload-Content-Type") String var3, @HeaderParam(value="X-Upload-Content-Length") String var4);

    @Named(value="Object:resumableUpload")
    @POST
    @QueryParams(keys={"uploadType"}, values={"resumable"})
    @Path(value="/upload/storage/v1/b/{bucket}/o")
    @ResponseParser(value=ParseToResumableUpload.class)
    public ResumableUpload initResumableUpload(@PathParam(value="bucket") String var1, @HeaderParam(value="X-Upload-Content-Type") String var2, @HeaderParam(value="X-Upload-Content-Length") Long var3, @BinderParam(value=BindToJsonPayload.class) ObjectTemplate var4);

    @Named(value="Object:resumableUpload")
    @PUT
    @QueryParams(keys={"uploadType"}, values={"resumable"})
    @Path(value="/upload/storage/v1/b/{bucket}/o")
    @MapBinder(value=UploadBinder.class)
    @ResponseParser(value=ParseToResumableUpload.class)
    public ResumableUpload upload(@PathParam(value="bucket") String var1, @QueryParam(value="upload_id") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Content-Length") String var4, @PayloadParam(value="payload") Payload var5);

    @Named(value="Object:Upload")
    @PUT
    @QueryParams(keys={"uploadType"}, values={"resumable"})
    @Path(value="/upload/storage/v1/b/{bucket}/o")
    @MapBinder(value=UploadBinder.class)
    @ResponseParser(value=ParseToResumableUpload.class)
    public ResumableUpload chunkUpload(@PathParam(value="bucket") String var1, @QueryParam(value="upload_id") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Content-Length") Long var4, @HeaderParam(value="Content-Range") String var5, @PayloadParam(value="payload") Payload var6);

    @Named(value="Object:Upload")
    @PUT
    @DefaultValue(value="0")
    @QueryParams(keys={"uploadType"}, values={"resumable"})
    @Path(value="/upload/storage/v1/b/{bucket}/o")
    @ResponseParser(value=ParseToResumableUpload.class)
    public ResumableUpload checkStatus(@PathParam(value="bucket") String var1, @QueryParam(value="upload_id") String var2, @HeaderParam(value="Content-Range") String var3);
}

