/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.blobstore.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Provides;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;
import org.jclouds.hpcloud.objectstorage.blobstore.HPCloudObjectStorageAsyncBlobStore;
import org.jclouds.hpcloud.objectstorage.blobstore.HPCloudObjectStorageBlobStore;
import org.jclouds.hpcloud.objectstorage.blobstore.functions.HPCloudObjectStorageObjectToBlobMetadata;
import org.jclouds.hpcloud.objectstorage.domain.CDNContainer;
import org.jclouds.hpcloud.objectstorage.extensions.CDNContainerApi;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.swift.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlobMetadata;

public class HPCloudObjectStorageBlobStoreContextModule
extends SwiftBlobStoreContextModule {
    @Provides
    @Singleton
    protected LoadingCache<String, URI> cdnContainer(GetCDNMetadata loader) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)loader);
    }

    protected void configure() {
        this.bind(ConsistencyModel.class).toInstance((Object)ConsistencyModel.STRICT);
        this.bind(AsyncBlobStore.class).to(HPCloudObjectStorageAsyncBlobStore.class);
        this.bind(BlobStore.class).to(HPCloudObjectStorageBlobStore.class);
        this.bind(ObjectToBlobMetadata.class).to(HPCloudObjectStorageObjectToBlobMetadata.class);
    }

    @Singleton
    @Beta
    public static final class GetCDNMetadata
    extends CacheLoader<String, URI> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final HPCloudObjectStorageApi client;

        @Inject
        public GetCDNMetadata(HPCloudObjectStorageApi client) {
            this.client = client;
        }

        public URI load(String container) {
            Optional<CDNContainerApi> cdnExtension = this.client.getCDNExtension();
            Preconditions.checkArgument((boolean)cdnExtension.isPresent(), (Object)"CDN is required, but the extension is not available!");
            try {
                CDNContainer md = ((CDNContainerApi)cdnExtension.get()).get(container);
                return md != null ? md.getCDNUri() : null;
            }
            catch (HttpResponseException e) {
                this.logger.trace("couldn't get cdn metadata for %s: %s", new Object[]{container, e.getMessage()});
                return null;
            }
            catch (NoSuchElementException e) {
                this.logger.trace("CDN may not be enabled. Couldn't get cdn metadata for %s: %s", new Object[]{container, e.getMessage()});
                return null;
            }
        }

        public String toString() {
            return "get()";
        }
    }
}

