/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageAsyncApi;
import org.jclouds.hpcloud.objectstorage.blobstore.HPCloudObjectStorageBlobRequestSigner;
import org.jclouds.hpcloud.objectstorage.blobstore.config.HPCloudObjectStorageBlobStoreContextModule;
import org.jclouds.hpcloud.objectstorage.config.HPCloudObjectStorageRestClientModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.keystone.v2_0.config.MappedAuthenticationApiModule;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURISupplier;
import org.jclouds.openstack.swift.SwiftKeystoneApiMetadata;
import org.jclouds.openstack.swift.blobstore.config.TemporaryUrlExtensionModule;
import org.jclouds.openstack.swift.extensions.KeystoneTemporaryUrlKeyAsyncApi;
import org.jclouds.openstack.swift.extensions.TemporaryUrlKeyApi;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.BinderUtils;

public class HPCloudObjectStorageApiMetadata
extends SwiftKeystoneApiMetadata {
    @Deprecated
    public static final TypeToken<RestContext<HPCloudObjectStorageApi, HPCloudObjectStorageAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<HPCloudObjectStorageApi, HPCloudObjectStorageAsyncApi>>(){
        private static final long serialVersionUID = 1L;
    };

    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public HPCloudObjectStorageApiMetadata() {
        this(new Builder());
    }

    protected HPCloudObjectStorageApiMetadata(Builder builder) {
        super((SwiftKeystoneApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = SwiftKeystoneApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.credential-type", "apiAccessKeyCredentials");
        return properties;
    }

    public static class IgnoreRegionVersionsModule
    extends KeystoneAuthenticationModule.RegionModule {
        protected RegionIdToURISupplier provideRegionIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, null);
        }

        protected RegionIdToAdminURISupplier provideRegionIdToAdminURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToAdminURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, null);
        }
    }

    public static class HPCloudObjectStorageTemporaryUrlExtensionModule
    extends TemporaryUrlExtensionModule<HPCloudObjectStorageAsyncApi> {
        protected void bindRequestSigner() {
            this.bind(BlobRequestSigner.class).to(HPCloudObjectStorageBlobRequestSigner.class);
        }

        protected void bindTemporaryUrlKeyApi() {
            BinderUtils.bindSyncToAsyncHttpApi((Binder)this.binder(), TemporaryUrlKeyApi.class, KeystoneTemporaryUrlKeyAsyncApi.class);
        }
    }

    public static class Builder
    extends SwiftKeystoneApiMetadata.Builder<Builder> {
        protected Builder() {
            super(HPCloudObjectStorageApi.class, HPCloudObjectStorageAsyncApi.class);
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("hpcloud-objectstorage")).endpointName("identity service url ending in /v2.0/")).defaultEndpoint("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/")).name("HP Cloud Services Object Storage API")).documentation(URI.create("https://build.hpcloud.com/object-storage/api"))).defaultProperties(HPCloudObjectStorageApiMetadata.defaultProperties())).context(CONTEXT_TOKEN)).defaultModules((Set)ImmutableSet.builder().add(MappedAuthenticationApiModule.class).add(HPCloudObjectStorageRestClientModule.HPCloudObjectStorageEndpointModule.class).add(IgnoreRegionVersionsModule.class).add(HPCloudObjectStorageRestClientModule.class).add(HPCloudObjectStorageBlobStoreContextModule.class).add(HPCloudObjectStorageTemporaryUrlExtensionModule.class).build());
        }

        public HPCloudObjectStorageApiMetadata build() {
            return new HPCloudObjectStorageApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

