/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListCDNContainerOptions
extends BaseHttpRequestOptions {
    public static final ListCDNContainerOptions NONE = new ListCDNContainerOptions();

    public ListCDNContainerOptions enabledOnly() {
        this.queryParameters.put((Object)"enabled_only", (Object)"true");
        return this;
    }

    public ListCDNContainerOptions afterMarker(String marker) {
        this.queryParameters.put((Object)"marker", Preconditions.checkNotNull((Object)marker, (Object)"marker"));
        return this;
    }

    public ListCDNContainerOptions maxResults(int limit) {
        Preconditions.checkState((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkState((limit <= 10000 ? 1 : 0) != 0, (Object)"limit must be <= 10000");
        this.queryParameters.put((Object)"limit", (Object)Integer.toString(limit));
        return this;
    }

    public static class Builder {
        public static ListCDNContainerOptions enabledOnly() {
            ListCDNContainerOptions options = new ListCDNContainerOptions();
            return options.enabledOnly();
        }

        public static ListCDNContainerOptions afterMarker(String marker) {
            ListCDNContainerOptions options = new ListCDNContainerOptions();
            return options.afterMarker(marker);
        }

        public static ListCDNContainerOptions maxResults(int limit) {
            ListCDNContainerOptions options = new ListCDNContainerOptions();
            return options.maxResults(limit);
        }
    }
}

