/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemCategory;

public class ProductItemPrice {
    private final int id;
    private final long itemId;
    private final Float recurringFee;
    private final Float hourlyRecurringFee;
    private final ProductItem item;
    private final Set<ProductItemCategory> categories;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromProductItemPrice(this);
    }

    @ConstructorProperties(value={"id", "itemId", "recurringFee", "hourlyRecurringFee", "item", "categories"})
    protected ProductItemPrice(int id, long itemId, @Nullable Float recurringFee, @Nullable Float hourlyRecurringFee, @Nullable ProductItem item, @Nullable Set<ProductItemCategory> categories) {
        this.id = id;
        this.itemId = itemId;
        this.recurringFee = recurringFee;
        this.hourlyRecurringFee = hourlyRecurringFee;
        this.item = item;
        this.categories = categories == null ? ImmutableSet.of() : ImmutableSet.copyOf(categories);
    }

    public int getId() {
        return this.id;
    }

    public long getItemId() {
        return this.itemId;
    }

    @Nullable
    public Float getRecurringFee() {
        return this.recurringFee;
    }

    @Nullable
    public Float getHourlyRecurringFee() {
        return this.hourlyRecurringFee;
    }

    @Nullable
    public ProductItem getItem() {
        return this.item;
    }

    public Set<ProductItemCategory> getCategories() {
        return this.categories;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductItemPrice that = (ProductItemPrice)ProductItemPrice.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("itemId", this.itemId).add("recurringFee", (Object)this.recurringFee).add("hourlyRecurringFee", (Object)this.hourlyRecurringFee).add("item", (Object)this.item).add("categories", this.categories);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected long itemId;
        protected Float recurringFee;
        protected Float hourlyRecurringFee;
        protected ProductItem item;
        protected Set<ProductItemCategory> categories = ImmutableSet.of();

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T itemId(long itemId) {
            this.itemId = itemId;
            return this.self();
        }

        public T recurringFee(Float recurringFee) {
            this.recurringFee = recurringFee;
            return this.self();
        }

        public T hourlyRecurringFee(Float hourlyRecurringFee) {
            this.hourlyRecurringFee = hourlyRecurringFee;
            return this.self();
        }

        public T item(ProductItem item) {
            this.item = item;
            return this.self();
        }

        public T categories(Set<ProductItemCategory> categories) {
            this.categories = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(categories, (Object)"categories")));
            return this.self();
        }

        public T categories(ProductItemCategory ... in) {
            return this.categories((Set<ProductItemCategory>)ImmutableSet.copyOf((Object[])in));
        }

        public ProductItemPrice build() {
            return new ProductItemPrice(this.id, this.itemId, this.recurringFee, this.hourlyRecurringFee, this.item, this.categories);
        }

        public T fromProductItemPrice(ProductItemPrice in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).itemId(in.getItemId())).recurringFee(in.getRecurringFee())).hourlyRecurringFee(in.getHourlyRecurringFee())).item(in.getItem())).categories(in.getCategories());
        }
    }
}

