/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.VirtualGuest;

public class ProductOrder {
    private final int packageId;
    private final String location;
    private final Set<ProductItemPrice> prices;
    private final Set<VirtualGuest> virtualGuests;
    private final int quantity;
    private final boolean useHourlyPricing;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromProductOrder(this);
    }

    @ConstructorProperties(value={"packageId", "location", "prices", "virtualGuest", "quantity", "useHourlyPricing"})
    protected ProductOrder(int packageId, @Nullable String location, @Nullable Set<ProductItemPrice> prices, @Nullable Set<VirtualGuest> virtualGuests, int quantity, boolean useHourlyPricing) {
        this.packageId = packageId;
        this.location = location;
        this.prices = prices == null ? ImmutableSet.of() : ImmutableSet.copyOf(prices);
        this.virtualGuests = virtualGuests == null ? ImmutableSet.of() : ImmutableSet.copyOf(virtualGuests);
        this.quantity = quantity;
        this.useHourlyPricing = useHourlyPricing;
    }

    public int getPackageId() {
        return this.packageId;
    }

    @Nullable
    public String getLocation() {
        return this.location;
    }

    public Set<ProductItemPrice> getPrices() {
        return this.prices;
    }

    public Set<VirtualGuest> getVirtualGuests() {
        return this.virtualGuests;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean getUseHourlyPricing() {
        return this.useHourlyPricing;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.packageId, this.location, this.prices, this.virtualGuests, this.quantity, this.useHourlyPricing});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductOrder that = (ProductOrder)ProductOrder.class.cast(obj);
        return Objects.equal((Object)this.packageId, (Object)that.packageId) && Objects.equal((Object)this.location, (Object)that.location) && Objects.equal(this.prices, that.prices) && Objects.equal(this.virtualGuests, that.virtualGuests) && Objects.equal((Object)this.quantity, (Object)that.quantity) && Objects.equal((Object)this.useHourlyPricing, (Object)that.useHourlyPricing);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("packageId", this.packageId).add("location", (Object)this.location).add("prices", this.prices).add("virtualGuests", this.virtualGuests).add("quantity", this.quantity).add("useHourlyPricing", this.useHourlyPricing);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int packageId;
        protected String location;
        protected Set<ProductItemPrice> prices = ImmutableSet.of();
        protected Set<VirtualGuest> virtualGuests = ImmutableSet.of();
        protected int quantity;
        protected boolean useHourlyPricing;

        protected abstract T self();

        public T packageId(int packageId) {
            this.packageId = packageId;
            return this.self();
        }

        public T location(String location) {
            this.location = location;
            return this.self();
        }

        public T prices(Iterable<ProductItemPrice> prices) {
            this.prices = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(prices, (Object)"prices")));
            return this.self();
        }

        public T prices(ProductItemPrice ... in) {
            return this.prices((Iterable<ProductItemPrice>)ImmutableSet.copyOf((Object[])in));
        }

        public T virtualGuests(Set<VirtualGuest> virtualGuests) {
            this.virtualGuests = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(virtualGuests, (Object)"virtualGuests")));
            return this.self();
        }

        public T virtualGuests(VirtualGuest ... in) {
            return this.virtualGuests((Set<VirtualGuest>)ImmutableSet.copyOf((Object[])in));
        }

        public T quantity(int quantity) {
            this.quantity = quantity;
            return this.self();
        }

        public T useHourlyPricing(boolean useHourlyPricing) {
            this.useHourlyPricing = useHourlyPricing;
            return this.self();
        }

        public ProductOrder build() {
            return new ProductOrder(this.packageId, this.location, this.prices, this.virtualGuests, this.quantity, this.useHourlyPricing);
        }

        public T fromProductOrder(ProductOrder in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.packageId(in.getPackageId())).location(in.getLocation())).prices(in.getPrices())).virtualGuests(in.getVirtualGuests())).quantity(in.getQuantity())).useHourlyPricing(in.getUseHourlyPricing());
        }
    }
}

