/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemCategory;

public class ProductItemPredicates {
    public static Predicate<ProductItem> categoryCode(final String category) {
        Preconditions.checkNotNull((Object)category, (Object)"category cannot be null");
        return new Predicate<ProductItem>(){

            public boolean apply(ProductItem productItem) {
                Preconditions.checkNotNull((Object)productItem, (Object)"productItem cannot ne null");
                for (ProductItemCategory productItemCategory : productItem.getCategories()) {
                    if (!category.equals(productItemCategory.getCategoryCode())) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "categoryCode(" + category + ")";
            }
        };
    }

    public static Predicate<ProductItem> categoryCodeMatches(final Pattern category) {
        Preconditions.checkNotNull((Object)category, (Object)"category cannot be null");
        return new Predicate<ProductItem>(){

            public boolean apply(ProductItem productItem) {
                Preconditions.checkNotNull((Object)productItem, (Object)"productItem cannot ne null");
                for (ProductItemCategory productItemCategory : productItem.getCategories()) {
                    if (!category.matcher(productItemCategory.getCategoryCode()).matches()) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "categoryCodeMatches(" + category + ")";
            }
        };
    }

    public static Predicate<ProductItem> capacity(final Float capacity) {
        Preconditions.checkNotNull((Object)capacity, (Object)"capacity cannot be null");
        return new Predicate<ProductItem>(){

            public boolean apply(ProductItem productItem) {
                Preconditions.checkNotNull((Object)productItem, (Object)"productItem cannot ne null");
                Float productItemCapacity = productItem.getCapacity();
                if (productItemCapacity == null) {
                    return false;
                }
                return capacity.equals(productItemCapacity);
            }

            public String toString() {
                return "capacity(" + capacity + ")";
            }
        };
    }

    public static Predicate<ProductItem> units(final String units) {
        Preconditions.checkNotNull((Object)units, (Object)"units cannot be null");
        return new Predicate<ProductItem>(){

            public boolean apply(ProductItem productItem) {
                Preconditions.checkNotNull((Object)productItem, (Object)"productItem cannot ne null");
                return units.equals(productItem.getUnits());
            }

            public String toString() {
                return "units(" + units + ")";
            }
        };
    }

    public static Predicate<ProductItem> matches(final Pattern regex) {
        Preconditions.checkNotNull((Object)regex, (Object)"regex cannot be null");
        return new Predicate<ProductItem>(){

            public boolean apply(ProductItem productItem) {
                Preconditions.checkNotNull((Object)productItem, (Object)"productItem cannot ne null");
                return regex.matcher(productItem.getDescription()).matches();
            }

            public String toString() {
                return "regex(" + regex + ")";
            }
        };
    }
}

