/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.softlayer.SoftLayerApi;
import org.jclouds.softlayer.compute.functions.DatacenterToLocation;
import org.jclouds.softlayer.compute.functions.ProductItemToImage;
import org.jclouds.softlayer.compute.functions.ProductItemsToHardware;
import org.jclouds.softlayer.compute.functions.VirtualGuestToNodeMetadata;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.compute.strategy.SoftLayerComputeServiceAdapter;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.ProductPackage;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.features.AccountApi;
import org.jclouds.softlayer.features.ProductPackageApi;
import org.jclouds.softlayer.predicates.ProductPackagePredicates;

public class SoftLayerComputeServiceContextModule
extends ComputeServiceAdapterContextModule<VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter>>(){}).to(SoftLayerComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VirtualGuest, NodeMetadata>>(){}).to(VirtualGuestToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ProductItem, Image>>(){}).to(ProductItemToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Iterable<ProductItem>, Hardware>>(){}).to(ProductItemsToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Datacenter, Location>>(){}).to(DatacenterToLocation.class);
        this.bind(TemplateOptions.class).to(SoftLayerTemplateOptions.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter>(){});
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<ProductPackage> getProductPackage(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, final SoftLayerApi client, final @Named(value="jclouds.softlayer.virtualguest.package-name") String virtualGuestPackageName) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, (Supplier)new Supplier<ProductPackage>(){

            public ProductPackage get() {
                AccountApi accountApi = client.getAccountApi();
                ProductPackageApi productPackageApi = client.getProductPackageApi();
                ProductPackage p = (ProductPackage)Iterables.find(accountApi.getActivePackages(), ProductPackagePredicates.named(virtualGuestPackageName));
                return productPackageApi.getProductPackage(p.getId());
            }

            public String toString() {
                return Objects.toStringHelper((Object)client).add("method", (Object)"accountClient.getActivePackages").add("method", (Object)"productPackageClient.getProductPackage").toString();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    public Iterable<ProductItemPrice> prices(@Named(value="jclouds.softlayer.virtualguest.prices") String prices) {
        return Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)Preconditions.checkNotNull((Object)prices, (Object)"prices")), (Function)new Function<String, ProductItemPrice>(){

            public ProductItemPrice apply(String arg0) {
                return ((ProductItemPrice.Builder)ProductItemPrice.builder().id(Integer.parseInt(arg0))).build();
            }
        });
    }
}

