/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.compute.functions.ProductItems;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;

@Singleton
public class ProductItemToImage
implements Function<ProductItem, Image> {
    private static final Pattern OS_BITS_PATTERN = Pattern.compile(".*\\((\\d+) ?bit\\).*");
    private static final String CENTOS = "CentOS";
    private static final String DEBIAN = "Debian GNU/Linux";
    private static final String FEDORA = "Fedora Release";
    private static final String RHEL = "Red Hat Enterprise Linux";
    private static final String UBUNTU = "Ubuntu Linux";
    private static final String WINDOWS = "Windows Server";
    private static final String CLOUD_LINUX = "CloudLinux";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public Image apply(ProductItem productItem) {
        String osVersion;
        Integer bits;
        Preconditions.checkNotNull((Object)productItem, (Object)"productItem");
        String description = (String)Preconditions.checkNotNull((Object)productItem.getDescription(), (Object)"productItem.description");
        OsFamily osFamily = (OsFamily)ProductItemToImage.osFamily().apply((Object)description);
        if (osFamily == OsFamily.UNRECOGNIZED) {
            this.logger.debug("Cannot determine os family for item: %s", new Object[]{productItem});
        }
        if ((bits = (Integer)ProductItemToImage.osBits().apply((Object)description)) == null) {
            this.logger.debug("Cannot determine os bits for item: %s", new Object[]{productItem});
        }
        if ((osVersion = (String)ProductItemToImage.osVersion().apply((Object)description)) == null) {
            this.logger.debug("Cannot determine os version for item: %s", new Object[]{productItem});
        }
        OperatingSystem os = OperatingSystem.builder().description(description).family(osFamily).version(osVersion).is64Bit(Objects.equal((Object)bits, (Object)64)).build();
        return new ImageBuilder().ids((String)ProductItemToImage.imageId().apply((Object)productItem)).description(description).operatingSystem(os).status(Image.Status.AVAILABLE).build();
    }

    public static Function<String, OsFamily> osFamily() {
        return new Function<String, OsFamily>(){

            public OsFamily apply(String description) {
                if (description != null) {
                    if (description.startsWith(ProductItemToImage.CENTOS)) {
                        return OsFamily.CENTOS;
                    }
                    if (description.startsWith(ProductItemToImage.DEBIAN)) {
                        return OsFamily.DEBIAN;
                    }
                    if (description.startsWith(ProductItemToImage.FEDORA)) {
                        return OsFamily.FEDORA;
                    }
                    if (description.startsWith(ProductItemToImage.RHEL)) {
                        return OsFamily.RHEL;
                    }
                    if (description.startsWith(ProductItemToImage.UBUNTU)) {
                        return OsFamily.UBUNTU;
                    }
                    if (description.startsWith(ProductItemToImage.WINDOWS)) {
                        return OsFamily.WINDOWS;
                    }
                    if (description.startsWith(ProductItemToImage.CLOUD_LINUX)) {
                        return OsFamily.CLOUD_LINUX;
                    }
                }
                return OsFamily.UNRECOGNIZED;
            }
        };
    }

    public static Function<String, String> osVersion() {
        return new Function<String, String>(){

            public String apply(String description) {
                OsFamily family = (OsFamily)ProductItemToImage.osFamily().apply((Object)description);
                if (Objects.equal((Object)family, (Object)OsFamily.CENTOS)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.CENTOS);
                }
                if (Objects.equal((Object)family, (Object)OsFamily.DEBIAN)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.DEBIAN);
                }
                if (Objects.equal((Object)family, (Object)OsFamily.FEDORA)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.FEDORA);
                }
                if (Objects.equal((Object)family, (Object)OsFamily.RHEL)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.RHEL);
                }
                if (Objects.equal((Object)family, (Object)OsFamily.UBUNTU)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.UBUNTU);
                }
                if (Objects.equal((Object)family, (Object)OsFamily.WINDOWS)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.WINDOWS);
                }
                if (Objects.equal((Object)family, (Object)OsFamily.CLOUD_LINUX)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.CLOUD_LINUX);
                }
                return null;
            }
        };
    }

    private static String parseVersion(String description, String os) {
        String noOsName = description.replaceFirst(os, "").trim();
        return noOsName.split(" ")[0];
    }

    public static Function<String, Integer> osBits() {
        return new Function<String, Integer>(){

            public Integer apply(String description) {
                Matcher m;
                if (description != null && (m = OS_BITS_PATTERN.matcher(description)).matches()) {
                    return Integer.parseInt(m.group(1));
                }
                return null;
            }
        };
    }

    public static Function<ProductItem, String> imageId() {
        return new Function<ProductItem, String>(){

            public String apply(ProductItem productItem) {
                Preconditions.checkNotNull((Object)productItem, (Object)"productItem");
                ProductItemPrice price = (ProductItemPrice)ProductItems.price().apply((Object)productItem);
                return "" + price.getId();
            }
        };
    }
}

