/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.softlayer.compute.functions.ProductItems;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.predicates.ProductItemPredicates;

@Singleton
public class ProductItemsToHardware
implements Function<Iterable<ProductItem>, Hardware> {
    private static final String GUEST_DISK_CATEGORY_REGEX = "guest_disk[0-9]";
    private static final String FIRST_GUEST_DISK = "guest_disk0";
    private static final String STORAGE_AREA_NETWORK = "SAN";
    private static final String RAM_CATEGORY = "ram";
    private static final String CPU_DESCRIPTION_REGEX = "(Private )?[0-9]+ x ([.0-9]+) GHz Core[s]?";
    private static final double DEFAULT_CORE_SPEED = 2.0;
    private final Pattern cpuDescriptionRegex;
    private final Pattern diskCategoryRegex;

    @Inject
    public ProductItemsToHardware() {
        this(Pattern.compile(CPU_DESCRIPTION_REGEX), Pattern.compile(GUEST_DISK_CATEGORY_REGEX));
    }

    public ProductItemsToHardware(Pattern cpuDescriptionRegex, Pattern diskCategoryRegex) {
        this.cpuDescriptionRegex = (Pattern)Preconditions.checkNotNull((Object)cpuDescriptionRegex, (Object)"cpuDescriptionRegex");
        this.diskCategoryRegex = (Pattern)Preconditions.checkNotNull((Object)diskCategoryRegex, (Object)"diskCategoryRegex");
    }

    public Hardware apply(Iterable<ProductItem> items) {
        ProductItem coresItem = (ProductItem)Iterables.getOnlyElement((Iterable)Iterables.filter(items, ProductItemPredicates.matches(this.cpuDescriptionRegex)));
        ProductItem ramItem = (ProductItem)Iterables.getOnlyElement((Iterable)Iterables.filter(items, ProductItemPredicates.categoryCode(RAM_CATEGORY)));
        ProductItem volumeItem = (ProductItem)Iterables.get((Iterable)Iterables.filter(items, ProductItemPredicates.categoryCode(FIRST_GUEST_DISK)), (int)0);
        String hardwareId = (String)ProductItemsToHardware.hardwareId().apply((Object)ImmutableList.of((Object)coresItem, (Object)ramItem, (Object)volumeItem));
        double cores = ((Float)ProductItems.capacity().apply((Object)coresItem)).doubleValue();
        Matcher cpuMatcher = this.cpuDescriptionRegex.matcher(coresItem.getDescription());
        double coreSpeed = cpuMatcher.matches() ? Double.parseDouble(cpuMatcher.group(cpuMatcher.groupCount())) : 2.0;
        int ram = ((Float)ProductItems.capacity().apply((Object)ramItem)).intValue() * 1024;
        return new HardwareBuilder().ids(hardwareId).processors((Iterable)ImmutableList.of((Object)new Processor(cores, coreSpeed))).ram(ram).hypervisor("XenServer").volumes(Iterables.transform((Iterable)Iterables.filter(items, ProductItemPredicates.categoryCodeMatches(this.diskCategoryRegex)), (Function)new Function<ProductItem, Volume>(){

            public Volume apply(ProductItem item) {
                float volumeSize = ((Float)ProductItems.capacity().apply((Object)item)).floatValue();
                return new VolumeImpl(item.getId() + "", item.getDescription().indexOf(ProductItemsToHardware.STORAGE_AREA_NETWORK) != -1 ? Volume.Type.SAN : Volume.Type.LOCAL, Float.valueOf(volumeSize), null, ProductItemPredicates.categoryCode(ProductItemsToHardware.FIRST_GUEST_DISK).apply((Object)item), false);
            }
        })).build();
    }

    public static Function<List<ProductItem>, String> hardwareId() {
        return new Function<List<ProductItem>, String>(){

            public String apply(List<ProductItem> productItems) {
                StringBuilder builder = new StringBuilder();
                for (ProductItem item : productItems) {
                    ProductItemPrice price = (ProductItemPrice)ProductItems.price().apply((Object)item);
                    builder.append(price.getId()).append(",");
                }
                return builder.toString().substring(0, builder.lastIndexOf(","));
            }
        };
    }
}

