/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.softlayer.binders.ProductOrderToJson;
import org.jclouds.softlayer.domain.ProductOrder;
import org.jclouds.softlayer.domain.ProductOrderReceipt;
import org.jclouds.softlayer.domain.VirtualGuest;

@RequestFilters(value={BasicAuthentication.class})
@Path(value="/v{jclouds.api-version}")
public interface VirtualGuestApi {
    public static final String LIST_GUEST_MASK = "virtualGuests.powerState;virtualGuests.networkVlans;virtualGuests.operatingSystem.passwords;virtualGuests.datacenter;virtualGuests.billingItem";
    public static final String GUEST_MASK = "powerState;networkVlans;operatingSystem.passwords;datacenter;billingItem";

    @GET
    @Path(value="/SoftLayer_Account/VirtualGuests.json")
    @QueryParams(keys={"objectMask"}, values={"virtualGuests.powerState;virtualGuests.networkVlans;virtualGuests.operatingSystem.passwords;virtualGuests.datacenter;virtualGuests.billingItem"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<VirtualGuest> listVirtualGuests();

    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}.json")
    @QueryParams(keys={"objectMask"}, values={"powerState;networkVlans;operatingSystem.passwords;datacenter;billingItem"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VirtualGuest getVirtualGuest(@PathParam(value="id") long var1);

    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/rebootHard.json")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void rebootHardVirtualGuest(@PathParam(value="id") long var1);

    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/powerOff.json")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void powerOffVirtualGuest(@PathParam(value="id") long var1);

    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/powerOn.json")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void powerOnVirtualGuest(@PathParam(value="id") long var1);

    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/pause.json")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void pauseVirtualGuest(@PathParam(value="id") long var1);

    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/resume.json")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void resumeVirtualGuest(@PathParam(value="id") long var1);

    @GET
    @Path(value="/SoftLayer_Billing_Item/{id}/cancelService.json")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean cancelService(@PathParam(value="id") long var1);

    @POST
    @Path(value="/SoftLayer_Product_Order/placeOrder.json")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ProductOrderReceipt orderVirtualGuest(@BinderParam(value=ProductOrderToJson.class) ProductOrder var1);

    @GET
    @Path(value="SoftLayer_Virtual_Guest/{id}/getOrderTemplate/MONTHLY.json")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ProductOrder getOrderTemplate(@PathParam(value="id") long var1);
}

