/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.SoftLayerApi;
import org.jclouds.softlayer.compute.functions.ProductItemToImage;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.Password;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.ProductOrder;
import org.jclouds.softlayer.domain.ProductOrderReceipt;
import org.jclouds.softlayer.domain.ProductPackage;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.predicates.ProductItemPredicates;
import org.jclouds.util.Predicates2;

@Singleton
public class SoftLayerComputeServiceAdapter
implements ComputeServiceAdapter<VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final SoftLayerApi client;
    private final Supplier<ProductPackage> productPackageSupplier;
    private final Predicate<VirtualGuest> loginDetailsTester;
    private final long guestLoginDelay;
    private final Pattern cpuPattern;
    private final Pattern disk0Type;
    private final float portSpeed;
    private final Iterable<ProductItemPrice> prices;

    @Inject
    public SoftLayerComputeServiceAdapter(SoftLayerApi client, VirtualGuestHasLoginDetailsPresent virtualGuestHasLoginDetailsPresent, @Memoized Supplier<ProductPackage> productPackageSupplier, Iterable<ProductItemPrice> prices, @Named(value="jclouds.softlayer.virtualguest.cpu-regex") String cpuRegex, @Named(value="jclouds.softlayer.virtualguest.disk0-type") String disk0Type, @Named(value="jclouds.softlayer.virtualguest.port-speed") float portSpeed, @Named(value="jclouds.softlayer.virtualguest.order-delay") long guestLoginDelay) {
        this.client = (SoftLayerApi)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.guestLoginDelay = guestLoginDelay;
        this.productPackageSupplier = (Supplier)Preconditions.checkNotNull(productPackageSupplier, (Object)"productPackageSupplier");
        Preconditions.checkArgument((guestLoginDelay > 500L ? 1 : 0) != 0, (Object)"guestOrderDelay must be in milliseconds and greater than 500");
        this.loginDetailsTester = Predicates2.retry((Predicate)virtualGuestHasLoginDetailsPresent, (long)guestLoginDelay);
        this.cpuPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)cpuRegex, (Object)"cpuRegex"));
        this.prices = (Iterable)Preconditions.checkNotNull(prices, (Object)"prices");
        this.portSpeed = portSpeed;
        Preconditions.checkArgument((portSpeed > 0.0f ? 1 : 0) != 0, (Object)"portSpeed must be greater than zero, often 10, 100, 1000, 10000");
        this.disk0Type = Pattern.compile(".*" + (String)Preconditions.checkNotNull((Object)disk0Type, (Object)"disk0Type") + ".*");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<VirtualGuest> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template was null");
        Preconditions.checkNotNull((Object)template.getOptions(), (Object)"template options was null");
        Preconditions.checkArgument((boolean)template.getOptions().getClass().isAssignableFrom(SoftLayerTemplateOptions.class), (String)"options class %s should have been assignable from SoftLayerTemplateOptions", (Object[])new Object[]{template.getOptions().getClass()});
        String domainName = ((SoftLayerTemplateOptions)template.getOptions().as(SoftLayerTemplateOptions.class)).getDomainName();
        VirtualGuest newGuest = ((VirtualGuest.Builder)((VirtualGuest.Builder)VirtualGuest.builder().domain(domainName)).hostname(name)).build();
        ProductOrder order = ((ProductOrder.Builder)((ProductOrder.Builder)((ProductOrder.Builder)((ProductOrder.Builder)((ProductOrder.Builder)((ProductOrder.Builder)ProductOrder.builder().packageId(((ProductPackage)this.productPackageSupplier.get()).getId())).location(template.getLocation().getId())).quantity(1)).useHourlyPricing(true)).prices(this.getPrices(template))).virtualGuests(newGuest)).build();
        this.logger.debug(">> ordering new virtualGuest domain(%s) hostname(%s)", new Object[]{domainName, name});
        ProductOrderReceipt productOrderReceipt = this.client.getVirtualGuestApi().orderVirtualGuest(order);
        VirtualGuest result = (VirtualGuest)Iterables.get(productOrderReceipt.getOrderDetails().getVirtualGuests(), (int)0);
        this.logger.trace("<< virtualGuest(%s)", new Object[]{result.getId()});
        this.logger.debug(">> awaiting login details for virtualGuest(%s)", new Object[]{result.getId()});
        boolean orderInSystem = this.loginDetailsTester.apply((Object)result);
        this.logger.trace("<< virtualGuest(%s) complete(%s)", new Object[]{result.getId(), orderInSystem});
        Preconditions.checkState((boolean)orderInSystem, (String)"order for guest %s doesn't have login details within %sms", (Object[])new Object[]{result, Long.toString(this.guestLoginDelay)});
        result = this.client.getVirtualGuestApi().getVirtualGuest(result.getId());
        Password pw = (Password)Iterables.get(result.getOperatingSystem().getPasswords(), (int)0);
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)result, result.getId() + "", LoginCredentials.builder().user(pw.getUsername()).password(pw.getPassword()).build());
    }

    private Iterable<ProductItemPrice> getPrices(Template template) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        int imageId = Integer.parseInt(template.getImage().getId());
        result.add((Object)((ProductItemPrice.Builder)ProductItemPrice.builder().id(imageId)).build());
        Iterable hardwareIds = Splitter.on((String)",").split((CharSequence)template.getHardware().getId());
        for (String hardwareId : hardwareIds) {
            int id = Integer.parseInt(hardwareId);
            result.add((Object)((ProductItemPrice.Builder)ProductItemPrice.builder().id(id)).build());
        }
        ProductItem uplinkItem = (ProductItem)Iterables.find(((ProductPackage)this.productPackageSupplier.get()).getItems(), (Predicate)Predicates.and(ProductItemPredicates.capacity(Float.valueOf(this.portSpeed)), ProductItemPredicates.categoryCode("port_speed")));
        result.add(Iterables.get(uplinkItem.getPrices(), (int)0));
        result.addAll(this.prices);
        return result.build();
    }

    public Iterable<Iterable<ProductItem>> listHardwareProfiles() {
        ProductPackage productPackage = (ProductPackage)this.productPackageSupplier.get();
        Set<ProductItem> items = productPackage.getItems();
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (ProductItem cpuItem : Iterables.filter(items, ProductItemPredicates.matches(this.cpuPattern))) {
            for (ProductItem ramItem : Iterables.filter(items, ProductItemPredicates.categoryCode("ram"))) {
                for (ProductItem sanItem : Iterables.filter(items, (Predicate)Predicates.and(ProductItemPredicates.matches(this.disk0Type), ProductItemPredicates.categoryCode("guest_disk0")))) {
                    result.add((Object)ImmutableSet.of((Object)cpuItem, (Object)ramItem, (Object)sanItem));
                }
            }
        }
        return result.build();
    }

    public Iterable<ProductItem> listImages() {
        return Iterables.filter(((ProductPackage)this.productPackageSupplier.get()).getItems(), ProductItemPredicates.categoryCode("os"));
    }

    public ProductItem getImage(final String id) {
        return (ProductItem)Iterables.find(this.listImages(), (Predicate)new Predicate<ProductItem>(){

            public boolean apply(ProductItem input) {
                return ((String)ProductItemToImage.imageId().apply((Object)input)).equals(id);
            }
        }, null);
    }

    public Iterable<VirtualGuest> listNodes() {
        return Iterables.filter(this.client.getVirtualGuestApi().listVirtualGuests(), (Predicate)new Predicate<VirtualGuest>(){

            public boolean apply(VirtualGuest arg0) {
                boolean hasBillingItem;
                boolean bl = hasBillingItem = arg0.getBillingItemId() != -1;
                if (hasBillingItem) {
                    return true;
                }
                SoftLayerComputeServiceAdapter.this.logger.trace("guest invalid, as it has no billing item %s", new Object[]{arg0});
                return false;
            }
        });
    }

    public Iterable<VirtualGuest> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<VirtualGuest>(){

            public boolean apply(VirtualGuest server) {
                return Iterables.contains((Iterable)ids, (Object)server.getId());
            }
        });
    }

    public Iterable<Datacenter> listLocations() {
        return ((ProductPackage)this.productPackageSupplier.get()).getDatacenters();
    }

    public VirtualGuest getNode(String id) {
        long serverId = Long.parseLong(id);
        return this.client.getVirtualGuestApi().getVirtualGuest(serverId);
    }

    public void destroyNode(String id) {
        VirtualGuest guest = this.getNode(id);
        if (guest == null) {
            return;
        }
        if (guest.getBillingItemId() == -1) {
            throw new IllegalStateException(String.format("no billing item for guest(%s) so we cannot cancel the order", id));
        }
        this.logger.debug(">> canceling service for guest(%s) billingItem(%s)", new Object[]{id, guest.getBillingItemId()});
        this.client.getVirtualGuestApi().cancelService(guest.getBillingItemId());
    }

    public void rebootNode(String id) {
        this.client.getVirtualGuestApi().rebootHardVirtualGuest(Long.parseLong(id));
    }

    public void resumeNode(String id) {
        this.client.getVirtualGuestApi().resumeVirtualGuest(Long.parseLong(id));
    }

    public void suspendNode(String id) {
        this.client.getVirtualGuestApi().pauseVirtualGuest(Long.parseLong(id));
    }

    public static class VirtualGuestHasLoginDetailsPresent
    implements Predicate<VirtualGuest> {
        private final SoftLayerApi client;

        @Inject
        public VirtualGuestHasLoginDetailsPresent(SoftLayerApi client) {
            this.client = (SoftLayerApi)Preconditions.checkNotNull((Object)client, (Object)"client was null");
        }

        public boolean apply(VirtualGuest guest) {
            Preconditions.checkNotNull((Object)guest, (Object)"virtual guest was null");
            VirtualGuest newGuest = this.client.getVirtualGuestApi().getVirtualGuest(guest.getId());
            boolean hasBackendIp = newGuest.getPrimaryBackendIpAddress() != null;
            boolean hasPrimaryIp = newGuest.getPrimaryIpAddress() != null;
            boolean hasPasswords = newGuest.getOperatingSystem() != null && newGuest.getOperatingSystem().getPasswords().size() > 0;
            return hasBackendIp && hasPrimaryIp && hasPasswords;
        }
    }
}

