/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.compute.functions.internal.OperatingSystems;
import org.jclouds.softlayer.domain.SoftwareDescription;
import org.jclouds.softlayer.domain.SoftwareLicense;

@Singleton
public class OperatingSystemToImage
implements Function<org.jclouds.softlayer.domain.OperatingSystem, Image> {
    private static final String UNRECOGNIZED = "UNRECOGNIZED";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public Image apply(org.jclouds.softlayer.domain.OperatingSystem operatingSystem) {
        Preconditions.checkNotNull((Object)operatingSystem, (Object)"operatingSystem");
        SoftwareLicense defaultSoftwareLicense = SoftwareLicense.builder().softwareDescription(SoftwareDescription.builder().build()).build();
        SoftwareLicense softwareLicense = (SoftwareLicense)Optional.fromNullable((Object)operatingSystem.getSoftwareLicense()).or((Object)defaultSoftwareLicense);
        Optional optOSReferenceCode = Optional.fromNullable((Object)softwareLicense.getSoftwareDescription().getReferenceCode());
        Optional optVersion = Optional.fromNullable((Object)softwareLicense.getSoftwareDescription().getVersion());
        Optional optLongDescription = Optional.fromNullable((Object)softwareLicense.getSoftwareDescription().getLongDescription());
        OsFamily osFamily = OsFamily.UNRECOGNIZED;
        String osVersion = UNRECOGNIZED;
        Integer bits = null;
        if (optOSReferenceCode.isPresent()) {
            String operatingSystemReferenceCode = (String)optOSReferenceCode.get();
            osFamily = (OsFamily)OperatingSystems.osFamily().apply((Object)operatingSystemReferenceCode);
            bits = (Integer)OperatingSystems.bits().apply((Object)operatingSystemReferenceCode);
        }
        if (optVersion.isPresent()) {
            osVersion = (String)OperatingSystems.version().apply(optVersion.get());
        }
        if (osFamily == OsFamily.UNRECOGNIZED) {
            this.logger.debug("Cannot determine os family for item: %s", new Object[]{operatingSystem});
        }
        if (osVersion == null) {
            this.logger.debug("Cannot determine os version for item: %s", new Object[]{operatingSystem});
        }
        if (bits == null) {
            this.logger.debug("Cannot determine os bits for item: %s", new Object[]{operatingSystem});
        }
        OperatingSystem os = OperatingSystem.builder().description((String)optLongDescription.or((Object)UNRECOGNIZED)).family(osFamily).version(osVersion).is64Bit(Objects.equal((Object)bits, (Object)64)).build();
        return new ImageBuilder().ids(operatingSystem.getId()).description((String)optOSReferenceCode.or((Object)UNRECOGNIZED)).operatingSystem(os).status(Image.Status.AVAILABLE).build();
    }
}

