/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.options;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InternetDomainName;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;

public class SoftLayerTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected String domainName = "jclouds.org";
    protected Optional<List<Integer>> blockDevices = Optional.absent();
    protected Optional<String> diskType = Optional.absent();
    protected Optional<Integer> portSpeed = Optional.absent();
    public static final SoftLayerTemplateOptions NONE = new SoftLayerTemplateOptions();

    public SoftLayerTemplateOptions clone() {
        SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof SoftLayerTemplateOptions) {
            SoftLayerTemplateOptions eTo = (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(to);
            eTo.domainName(this.domainName);
            if (this.blockDevices.isPresent()) {
                eTo.blockDevices((Iterable)this.blockDevices.get());
            }
            if (this.diskType.isPresent()) {
                eTo.diskType((String)this.diskType.get());
            }
            if (this.portSpeed.isPresent()) {
                eTo.portSpeed((Integer)this.portSpeed.get());
            }
        }
    }

    public TemplateOptions domainName(String domainName) {
        Preconditions.checkNotNull((Object)domainName, (Object)"domainName was null");
        Preconditions.checkArgument((boolean)InternetDomainName.from((String)domainName).hasPublicSuffix(), (String)"domainName %s has no public suffix", (Object[])new Object[]{domainName});
        this.domainName = domainName;
        return this;
    }

    public TemplateOptions blockDevices(Iterable<Integer> capacities) {
        for (Integer capacity : (Iterable)Preconditions.checkNotNull(capacities, (Object)"capacities")) {
            Preconditions.checkNotNull((Object)capacity, (Object)"all block devices must be non-empty");
        }
        this.blockDevices = Optional.of((Object)ImmutableList.copyOf(capacities));
        return this;
    }

    public TemplateOptions blockDevices(Integer ... capacities) {
        return this.blockDevices((Iterable<Integer>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)capacities, (Object)"capacities"))));
    }

    public TemplateOptions diskType(String diskType) {
        Preconditions.checkNotNull((Object)diskType, (Object)"diskType was null");
        this.diskType = Optional.of((Object)diskType);
        return this;
    }

    public TemplateOptions portSpeed(Integer portSpeed) {
        Preconditions.checkNotNull((Object)portSpeed, (Object)"portSpeed was null");
        this.portSpeed = Optional.of((Object)portSpeed);
        return this;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Optional<List<Integer>> getBlockDevices() {
        return this.blockDevices;
    }

    public Optional<String> getDiskType() {
        return this.diskType;
    }

    public Optional<Integer> getPortSpeed() {
        return this.portSpeed;
    }

    public SoftLayerTemplateOptions blockOnPort(int port, int seconds) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public SoftLayerTemplateOptions inboundPorts(int ... ports) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public SoftLayerTemplateOptions authorizePublicKey(String publicKey) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public SoftLayerTemplateOptions installPrivateKey(String privateKey) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public SoftLayerTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public SoftLayerTemplateOptions userMetadata(String key, String value) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public SoftLayerTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public SoftLayerTemplateOptions networks(Iterable<String> networks) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static SoftLayerTemplateOptions domainName(String domainName) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.domainName(domainName));
        }

        public static SoftLayerTemplateOptions blockDevices(Integer ... capacities) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.blockDevices(capacities));
        }

        public static SoftLayerTemplateOptions blockDevices(Iterable<Integer> capacities) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.blockDevices(capacities));
        }

        public static SoftLayerTemplateOptions diskType(String diskType) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.diskType(diskType));
        }

        public static SoftLayerTemplateOptions portSpeed(Integer portSpeed) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.portSpeed(portSpeed));
        }

        public static SoftLayerTemplateOptions inboundPorts(int ... ports) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static SoftLayerTemplateOptions blockOnPort(int port, int seconds) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static SoftLayerTemplateOptions userMetadata(Map<String, String> userMetadata) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static SoftLayerTemplateOptions userMetadata(String key, String value) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.userMetadata(key, value));
        }

        public static SoftLayerTemplateOptions nodeNames(Iterable<String> nodeNames) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.nodeNames((Iterable)nodeNames));
        }

        public static SoftLayerTemplateOptions networks(Iterable<String> networks) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.networks((Iterable)networks));
        }
    }
}

