/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.SoftLayerApi;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.domain.ContainerVirtualGuestConfiguration;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.OperatingSystem;
import org.jclouds.softlayer.domain.Password;
import org.jclouds.softlayer.domain.SoftwareDescription;
import org.jclouds.softlayer.domain.SoftwareLicense;
import org.jclouds.softlayer.domain.VirtualDiskImage;
import org.jclouds.softlayer.domain.VirtualDiskImageSoftware;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.domain.VirtualGuestBlockDevice;
import org.jclouds.softlayer.domain.VirtualGuestBlockDeviceTemplate;
import org.jclouds.softlayer.domain.VirtualGuestBlockDeviceTemplateGroup;
import org.jclouds.softlayer.domain.VirtualGuestNetworkComponent;
import org.jclouds.util.Predicates2;

@Singleton
public class SoftLayerComputeServiceAdapter
implements ComputeServiceAdapter<VirtualGuest, Hardware, OperatingSystem, Datacenter> {
    private static final String BOOTABLE_DEVICE = "0";
    public static final String DEFAULT_DISK_TYPE = "LOCAL";
    public static final int DEFAULT_PORT_SPEED = 100;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final SoftLayerApi api;
    private final Supplier<ContainerVirtualGuestConfiguration> createObjectOptionsSupplier;
    private final Predicate<VirtualGuest> loginDetailsTester;
    private final long guestLoginDelay;
    private final long activeTransactionsDelay;
    private final boolean includePublicImages;

    @Inject
    public SoftLayerComputeServiceAdapter(SoftLayerApi api, VirtualGuestHasLoginDetailsPresent virtualGuestHasLoginDetailsPresent, @Memoized Supplier<ContainerVirtualGuestConfiguration> createObjectOptionsSupplier, @Named(value="jclouds.softlayer.virtualguest.login_details_delay") long guestLoginDelay, @Named(value="jclouds.softlayer.virtualguest.active_transactions_delay") long activeTransactionsDelay, @Named(value="jclouds.softlayer.include_public_images") boolean includePublicImages) {
        this.api = (SoftLayerApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.guestLoginDelay = (Long)Preconditions.checkNotNull((Object)guestLoginDelay, (Object)"guestLoginDelay");
        this.activeTransactionsDelay = (Long)Preconditions.checkNotNull((Object)activeTransactionsDelay, (Object)"activeTransactionsDelay");
        this.includePublicImages = (Boolean)Preconditions.checkNotNull((Object)includePublicImages, (Object)"includePublicImages");
        this.createObjectOptionsSupplier = (Supplier)Preconditions.checkNotNull(createObjectOptionsSupplier, (Object)"createObjectOptionsSupplier");
        Preconditions.checkArgument((guestLoginDelay > 500L ? 1 : 0) != 0, (Object)"guestOrderDelay must be in milliseconds and greater than 500");
        this.loginDetailsTester = Predicates2.retry((Predicate)virtualGuestHasLoginDetailsPresent, (long)guestLoginDelay);
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<VirtualGuest> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template was null");
        Preconditions.checkNotNull((Object)template.getOptions(), (Object)"template options was null");
        Preconditions.checkArgument((boolean)template.getOptions().getClass().isAssignableFrom(SoftLayerTemplateOptions.class), (String)"options class %s should have been assignable from SoftLayerTemplateOptions", (Object[])new Object[]{template.getOptions().getClass()});
        SoftLayerTemplateOptions templateOptions = (SoftLayerTemplateOptions)template.getOptions().as(SoftLayerTemplateOptions.class);
        String domainName = templateOptions.getDomainName();
        String diskType = (String)templateOptions.getDiskType().or((Object)DEFAULT_DISK_TYPE);
        int portSpeed = (Integer)templateOptions.getPortSpeed().or((Object)100);
        Datacenter datacenter = ((Datacenter.Builder)Datacenter.builder().name(template.getLocation().getId())).build();
        String imageId = template.getImage().getId();
        int cores = (int)((Processor)template.getHardware().getProcessors().get(0)).getCores();
        Object virtualGuestBuilder = ((VirtualGuest.Builder)((VirtualGuest.Builder)((VirtualGuest.Builder)((VirtualGuest.Builder)((VirtualGuest.Builder)VirtualGuest.builder().domain(domainName)).hostname(name)).startCpus(cores)).maxMemory(template.getHardware().getRam())).datacenter(datacenter)).networkComponents(VirtualGuestNetworkComponent.builder().speed(portSpeed).build());
        Optional<OperatingSystem> optionalOperatingSystem = this.tryGetOperatingSystemFrom(imageId);
        if (optionalOperatingSystem.isPresent()) {
            ((VirtualGuest.Builder)virtualGuestBuilder).operatingSystem((OperatingSystem)optionalOperatingSystem.get());
        } else {
            VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup = VirtualGuestBlockDeviceTemplateGroup.builder().globalIdentifier(imageId).build();
            ((VirtualGuest.Builder)((VirtualGuest.Builder)virtualGuestBuilder).blockDeviceTemplateGroup(blockDeviceTemplateGroup)).build();
        }
        if (templateOptions.getBlockDevices().isPresent()) {
            Set<VirtualGuestBlockDevice> blockDevices = this.getBlockDevices((List)templateOptions.getBlockDevices().get(), diskType);
            ((VirtualGuest.Builder)virtualGuestBuilder).blockDevices(blockDevices);
            ((VirtualGuest.Builder)virtualGuestBuilder).localDiskFlag(this.isLocalDisk(diskType));
        }
        VirtualGuest virtualGuest = ((VirtualGuest.Builder)virtualGuestBuilder).build();
        this.logger.debug(">> creating new VirtualGuest(%s)", new Object[]{virtualGuest});
        VirtualGuest result = this.api.getVirtualGuestApi().createVirtualGuest(virtualGuest);
        this.logger.trace("<< VirtualGuest(%s)", new Object[]{result.getId()});
        if (templateOptions.getTags() != null) {
            this.api.getVirtualGuestApi().setTags(result.getId(), templateOptions.getTags());
        }
        this.logger.debug(">> awaiting login details for virtualGuest(%s)", new Object[]{result.getId()});
        boolean orderInSystem = this.loginDetailsTester.apply((Object)result);
        this.logger.trace("<< VirtualGuest(%s) complete(%s)", new Object[]{result.getId(), orderInSystem});
        if (!orderInSystem) {
            this.logger.warn("VirtualGuest(%s) doesn't have login details within %sms so it will be destroyed.", new Object[]{result, Long.toString(this.guestLoginDelay)});
            this.api.getVirtualGuestApi().deleteVirtualGuest(result.getId());
            throw new IllegalStateException(String.format("VirtualGuest(%s) is being destroyed as it doesn't have login details after %sms. Please, try by increasing `jclouds.softlayer.virtualguest.login_details_delay` and  try again", result, Long.toString(this.guestLoginDelay)));
        }
        result = this.api.getVirtualGuestApi().getVirtualGuest(result.getId());
        Password pwd = (Password)Iterables.get(result.getOperatingSystem().getPasswords(), (int)0);
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)result, result.getId() + "", LoginCredentials.builder().user(pwd.getUsername()).password(pwd.getPassword()).build());
    }

    private Set<VirtualGuestBlockDevice> getBlockDevices(List<Integer> blockDeviceCapacities, String diskType) {
        HashSet blockDevices = Sets.newHashSet();
        int devicePosition = 0;
        for (int i = 0; i < blockDeviceCapacities.size(); ++i) {
            if (i > 0) {
                devicePosition = i + 1;
            }
            blockDevices.add(VirtualGuestBlockDevice.builder().device(devicePosition + "").diskImage(VirtualDiskImage.builder().capacity(blockDeviceCapacities.get(i).intValue()).typeId(Volume.Type.valueOf((String)diskType).ordinal()).build()).build());
        }
        return blockDevices;
    }

    private Optional<OperatingSystem> tryGetOperatingSystemFrom(final String imageId) {
        Set<OperatingSystem> operatingSystemsAvailable = ((ContainerVirtualGuestConfiguration)this.createObjectOptionsSupplier.get()).getVirtualGuestOperatingSystems();
        return Iterables.tryFind((Iterable)FluentIterable.from(operatingSystemsAvailable).filter((Predicate)new Predicate<OperatingSystem>(){

            public boolean apply(OperatingSystem input) {
                return input.getId().contains(imageId);
            }
        }), (Predicate)Predicates.notNull());
    }

    private boolean isLocalDisk(String diskType) {
        return diskType.equalsIgnoreCase(Volume.Type.LOCAL.name());
    }

    public Iterable<Hardware> listHardwareProfiles() {
        ContainerVirtualGuestConfiguration virtualGuestConfiguration = (ContainerVirtualGuestConfiguration)this.createObjectOptionsSupplier.get();
        ImmutableSortedSet.Builder hardware = ImmutableSortedSet.orderedBy((Comparator)new Comparator<Hardware>(){

            @Override
            public int compare(Hardware h1, Hardware h2) {
                List volumes1 = h1.getVolumes();
                List volumes2 = h2.getVolumes();
                ComparisonChain comparisonChain = ComparisonChain.start().compare(ComputeServiceUtils.getCores((Hardware)h1), ComputeServiceUtils.getCores((Hardware)h2)).compare(h1.getRam(), h2.getRam()).compare(ComputeServiceUtils.getSpace((Hardware)h1), ComputeServiceUtils.getSpace((Hardware)h2)).compare(SoftLayerComputeServiceAdapter.this.getBootableDeviceType(h1), SoftLayerComputeServiceAdapter.this.getBootableDeviceType(h2));
                if (!volumes1.isEmpty() && !volumes2.isEmpty() && volumes1.size() == volumes2.size()) {
                    for (int i = 0; i < volumes1.size(); ++i) {
                        comparisonChain.compare((Comparable)((Volume)volumes1.get(i)).getType(), (Comparable)((Volume)volumes2.get(i)).getType());
                    }
                }
                return comparisonChain.result();
            }
        });
        for (VirtualGuestBlockDevice blockDevice : virtualGuestConfiguration.getVirtualGuestBlockDevices()) {
            Volume.Type type;
            float capacity = blockDevice.getVirtualDiskImage().getCapacity();
            Volume.Type type2 = type = blockDevice.getVirtualGuest().isLocalDiskFlag() ? Volume.Type.LOCAL : Volume.Type.SAN;
            if (!blockDevice.getDevice().equals(BOOTABLE_DEVICE)) continue;
            for (Integer cpus : virtualGuestConfiguration.getCpusOfProcessors()) {
                for (Integer memory : virtualGuestConfiguration.getMemories()) {
                    String id = String.format("cpu=%s,memory=%s,disk=%s,type=%s", cpus, memory, Math.round(capacity), type);
                    hardware.add((Object)new HardwareBuilder().ids(id).ram(memory.intValue()).processors((Iterable)ImmutableList.of((Object)new Processor((double)cpus.intValue(), 2.0))).hypervisor("XenServer").volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(blockDevice.getId() + "", type, Float.valueOf(capacity), blockDevice.getDevice(), blockDevice.getBootableFlag() == 1, true))).build());
                }
            }
        }
        return hardware.build();
    }

    private int getBootableDeviceType(Hardware hardware) {
        List volumes = hardware.getVolumes();
        Optional optionalBootableVolume = Iterables.tryFind((Iterable)volumes, (Predicate)new Predicate<Volume>(){

            public boolean apply(Volume volume) {
                return volume.getDevice().equals(SoftLayerComputeServiceAdapter.BOOTABLE_DEVICE);
            }
        });
        if (!optionalBootableVolume.isPresent()) {
            return Volume.Type.LOCAL.ordinal();
        }
        return ((Volume)optionalBootableVolume.get()).getType().ordinal();
    }

    public Set<OperatingSystem> listImages() {
        HashSet result = Sets.newHashSet();
        Set<SoftwareDescription> unfiltered = this.api.getSoftwareDescriptionApi().getAllObjects();
        Set<OperatingSystem> operatingSystemsAvailable = ((ContainerVirtualGuestConfiguration)this.createObjectOptionsSupplier.get()).getVirtualGuestOperatingSystems();
        for (OperatingSystem os : operatingSystemsAvailable) {
            final String osReferenceCode = os.getOperatingSystemReferenceCode();
            String osId = os.getId();
            result.addAll(FluentIterable.from(unfiltered).filter((Predicate)new Predicate<SoftwareDescription>(){

                public boolean apply(SoftwareDescription input) {
                    return SoftLayerComputeServiceAdapter.this.isOperatingSystem(input) && input.getReferenceCode().equals(osReferenceCode);
                }
            }).transform((Function)new SoftwareDescriptionToOperatingSystem(osId, osReferenceCode)).toSet());
        }
        Set<VirtualGuestBlockDeviceTemplateGroup> privateImages = this.api.getAccountApi().getBlockDeviceTemplateGroups();
        Map<String, SoftwareDescription> privateImagesSoftwareDescriptions = this.extractSoftwareDescriptions(privateImages);
        for (Map.Entry<String, SoftwareDescription> entry : privateImagesSoftwareDescriptions.entrySet()) {
            OperatingSystem os = this.getOperatingSystem(entry);
            if (os == null) continue;
            result.add(os);
        }
        if (this.includePublicImages) {
            Set<VirtualGuestBlockDeviceTemplateGroup> publicImages = this.api.getVirtualGuestBlockDeviceTemplateGroupApi().getPublicImages();
            Map<String, SoftwareDescription> publicImagesSoftwareDescriptions = this.extractSoftwareDescriptions(publicImages);
            for (Map.Entry<String, SoftwareDescription> entry : publicImagesSoftwareDescriptions.entrySet()) {
                OperatingSystem os = this.getOperatingSystem(entry);
                if (os == null) continue;
                result.add(os);
            }
        }
        return result;
    }

    private OperatingSystem getOperatingSystem(Map.Entry<String, SoftwareDescription> entry) {
        SoftwareDescription softwareDescription = entry.getValue();
        if (this.isOperatingSystem(softwareDescription)) {
            String uuid = entry.getKey();
            return OperatingSystem.builder().id(uuid).softwareLicense(SoftwareLicense.builder().softwareDescription(softwareDescription).build()).operatingSystemReferenceCode(softwareDescription.getReferenceCode()).build();
        }
        return null;
    }

    private Map<String, SoftwareDescription> extractSoftwareDescriptions(Set<VirtualGuestBlockDeviceTemplateGroup> images) {
        HashMap softwareDescriptions = Maps.newHashMap();
        for (VirtualGuestBlockDeviceTemplateGroup image : images) {
            String globalIdentifier = image.getGlobalIdentifier();
            for (VirtualGuestBlockDeviceTemplateGroup child : image.getChildren()) {
                for (VirtualGuestBlockDeviceTemplate blockDeviceTemplate : child.getBlockDevices()) {
                    for (VirtualDiskImageSoftware softwareReference : blockDeviceTemplate.getDiskImage().getSoftwareReferences()) {
                        softwareDescriptions.put(globalIdentifier, softwareReference.getSoftwareDescription());
                    }
                }
            }
        }
        return softwareDescriptions;
    }

    public OperatingSystem getImage(final String id) {
        return (OperatingSystem)Iterables.find((Iterable)this.listImages(), (Predicate)new Predicate<OperatingSystem>(){

            public boolean apply(OperatingSystem input) {
                return input.getId().equals(id);
            }
        }, null);
    }

    public Iterable<VirtualGuest> listNodes() {
        return this.api.getAccountApi().listVirtualGuests();
    }

    public Iterable<VirtualGuest> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<VirtualGuest>(){

            public boolean apply(VirtualGuest server) {
                return Iterables.contains((Iterable)ids, (Object)server.getId());
            }
        });
    }

    public Iterable<Datacenter> listLocations() {
        HashSet result = Sets.newHashSet();
        Set<Datacenter> unfiltered = this.api.getDatacenterApi().listDatacenters();
        Set<Datacenter> datacenterAvailable = ((ContainerVirtualGuestConfiguration)this.createObjectOptionsSupplier.get()).getVirtualGuestDatacenters();
        for (Datacenter datacenter : datacenterAvailable) {
            final String datacenterName = datacenter.getName();
            result.addAll(Sets.newHashSet((Iterable)Iterables.filter(unfiltered, (Predicate)new Predicate<Datacenter>(){

                public boolean apply(Datacenter input) {
                    return input.getName().equals(datacenterName);
                }
            })));
        }
        return result;
    }

    public VirtualGuest getNode(String id) {
        long serverId = Long.parseLong(id);
        return this.api.getVirtualGuestApi().getVirtualGuest(serverId);
    }

    public void destroyNode(String id) {
        VirtualGuest guest = this.getNode(id);
        if (guest == null) {
            return;
        }
        this.logger.debug(">> awaiting virtualGuest(%s) without active transactions", new Object[]{guest.getId()});
        Preconditions.checkState((boolean)Predicates2.retry((Predicate)new Predicate<VirtualGuest>(){

            public boolean apply(VirtualGuest guest) {
                return SoftLayerComputeServiceAdapter.this.getNode(guest.getId() + "").getActiveTransactionCount() == 0;
            }
        }, (long)this.activeTransactionsDelay).apply((Object)guest), (String)"%s still has active transactions!", (Object[])new Object[]{guest});
        this.logger.debug(">> canceling virtualGuest with globalIdentifier(%s)", new Object[]{id});
        Preconditions.checkState((boolean)this.api.getVirtualGuestApi().deleteVirtualGuest(guest.getId()), (String)"server(%s) still there after deleting!?", (Object[])new Object[]{id});
    }

    public void rebootNode(String id) {
        this.api.getVirtualGuestApi().rebootHardVirtualGuest(Long.parseLong(id));
    }

    public void resumeNode(String id) {
        this.api.getVirtualGuestApi().resumeVirtualGuest(Long.parseLong(id));
    }

    public void suspendNode(String id) {
        this.api.getVirtualGuestApi().pauseVirtualGuest(Long.parseLong(id));
    }

    private boolean isOperatingSystem(SoftwareDescription input) {
        return input.getOperatingSystem() == 1;
    }

    private static class SoftwareDescriptionToOperatingSystem
    implements Function<SoftwareDescription, OperatingSystem> {
        private final String osId;
        private final String operatingSystemReferenceCode;

        public SoftwareDescriptionToOperatingSystem(String osId, String operatingSystemReferenceCode) {
            this.osId = osId;
            this.operatingSystemReferenceCode = operatingSystemReferenceCode;
        }

        public OperatingSystem apply(SoftwareDescription input) {
            return OperatingSystem.builder().id(this.osId).softwareLicense(SoftwareLicense.builder().softwareDescription(input).build()).operatingSystemReferenceCode(this.operatingSystemReferenceCode).build();
        }
    }

    public static class VirtualGuestHasLoginDetailsPresent
    implements Predicate<VirtualGuest> {
        private final SoftLayerApi client;

        @Inject
        public VirtualGuestHasLoginDetailsPresent(SoftLayerApi client) {
            this.client = (SoftLayerApi)Preconditions.checkNotNull((Object)client, (Object)"client was null");
        }

        public boolean apply(VirtualGuest guest) {
            Preconditions.checkNotNull((Object)guest, (Object)"virtual guest was null");
            VirtualGuest newGuest = this.client.getVirtualGuestApi().getVirtualGuest(guest.getId());
            boolean hasBackendIp = newGuest.getPrimaryBackendIpAddress() != null;
            boolean hasPrimaryIp = newGuest.getPrimaryIpAddress() != null;
            boolean hasPasswords = newGuest.getOperatingSystem() != null && newGuest.getOperatingSystem().getPasswords().size() > 0;
            return hasBackendIp && hasPrimaryIp && hasPasswords;
        }
    }
}

