/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.Password;
import org.jclouds.softlayer.domain.SoftwareLicense;

public class OperatingSystem {
    private final String id;
    private final SoftwareLicense softwareLicense;
    private final String operatingSystemReferenceCode;
    private final Set<Password> passwords;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return OperatingSystem.builder().fromOperatingSystem(this);
    }

    @ConstructorProperties(value={"id", "softwareLicense", "operatingSystemReferenceCode", "passwords"})
    protected OperatingSystem(String id, @Nullable SoftwareLicense softwareLicense, @Nullable String operatingSystemReferenceCode, @Nullable Set<Password> passwords) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.softwareLicense = softwareLicense;
        this.operatingSystemReferenceCode = operatingSystemReferenceCode;
        this.passwords = passwords == null ? ImmutableSet.of() : ImmutableSet.copyOf(passwords);
    }

    public String getId() {
        return this.id;
    }

    public SoftwareLicense getSoftwareLicense() {
        return this.softwareLicense;
    }

    public String getOperatingSystemReferenceCode() {
        return this.operatingSystemReferenceCode;
    }

    public Set<Password> getPasswords() {
        return this.passwords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatingSystem that = (OperatingSystem)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.softwareLicense, (Object)that.softwareLicense) && Objects.equal((Object)this.operatingSystemReferenceCode, (Object)that.operatingSystemReferenceCode) && Objects.equal(this.passwords, that.passwords);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.softwareLicense, this.operatingSystemReferenceCode, this.passwords});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("softwareLicense", (Object)this.softwareLicense).add("operatingSystemReferenceCode", (Object)this.operatingSystemReferenceCode).add("passwords", this.passwords).toString();
    }

    public static class Builder {
        protected String id;
        protected SoftwareLicense softwareLicense;
        protected String operatingSystemReferenceCode;
        protected Set<Password> passwords = ImmutableSet.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder softwareLicense(SoftwareLicense softwareLicense) {
            this.softwareLicense = softwareLicense;
            return this;
        }

        public Builder operatingSystemReferenceCode(String operatingSystemReferenceCode) {
            this.operatingSystemReferenceCode = operatingSystemReferenceCode;
            return this;
        }

        public Builder passwords(Set<Password> passwords) {
            this.passwords = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(passwords, (Object)"passwords")));
            return this;
        }

        public Builder passwords(Password ... in) {
            return this.passwords((Set<Password>)ImmutableSet.copyOf((Object[])in));
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.id, this.softwareLicense, this.operatingSystemReferenceCode, this.passwords);
        }

        public Builder fromOperatingSystem(OperatingSystem in) {
            return this.id(in.getId()).passwords(in.getPasswords());
        }
    }
}

