/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.OperatingSystem;
import org.jclouds.softlayer.domain.PowerState;
import org.jclouds.softlayer.domain.SoftwareLicense;
import org.jclouds.softlayer.domain.TagReference;
import org.jclouds.softlayer.domain.VirtualGuestBlockDevice;
import org.jclouds.softlayer.domain.VirtualGuestBlockDeviceTemplateGroup;
import org.jclouds.softlayer.domain.VirtualGuestNetworkComponent;

public class VirtualGuest {
    private final int accountId;
    private final Date createDate;
    private final boolean dedicatedAccountHostOnly;
    private final String domain;
    private final String fullyQualifiedDomainName;
    private final String hostname;
    private final int id;
    private final Date lastVerifiedDate;
    private final int maxCpu;
    private final String maxCpuUnits;
    private final int maxMemory;
    private final Date metricPollDate;
    private final Date modifyDate;
    private final String notes;
    private final boolean privateNetworkOnly;
    private final int startCpus;
    private final int statusId;
    private final String uuid;
    private final String primaryBackendIpAddress;
    private final String primaryIpAddress;
    private final int billingItemId;
    private final OperatingSystem operatingSystem;
    private final String operatingSystemReferenceCode;
    private final Datacenter datacenter;
    private final PowerState powerState;
    private final SoftwareLicense softwareLicense;
    private final int activeTransactionCount;
    private final Set<VirtualGuestBlockDevice> blockDevices;
    private final boolean localDiskFlag;
    private final VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup;
    private final Set<VirtualGuestNetworkComponent> networkComponents;
    private final Set<TagReference> tagReferences;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVirtualGuest(this);
    }

    @ConstructorProperties(value={"accountId", "createDate", "dedicatedAccountHostOnlyFlag", "domain", "fullyQualifiedDomainName", "hostname", "id", "lastVerifiedDate", "maxCpu", "maxCpuUnits", "maxMemory", "metricPollDate", "modifyDate", "notes", "privateNetworkOnlyFlag", "startCpus", "statusId", "uuid", "primaryBackendIpAddress", "primaryIpAddress", "billingItem", "operatingSystem", "operatingSystemReferenceCode", "datacenter", "powerState", "softwareLicense", "activeTransactionCount", "blockDevices", "localDiskFlag", "blockDeviceTemplateGroup", "networkComponents", "tagReferences"})
    protected VirtualGuest(int accountId, @Nullable Date createDate, boolean dedicatedAccountHostOnly, @Nullable String domain, @Nullable String fullyQualifiedDomainName, @Nullable String hostname, int id, @Nullable Date lastVerifiedDate, int maxCpu, @Nullable String maxCpuUnits, int maxMemory, @Nullable Date metricPollDate, @Nullable Date modifyDate, @Nullable String notes, boolean privateNetworkOnly, int startCpus, int statusId, @Nullable String uuid, @Nullable String primaryBackendIpAddress, @Nullable String primaryIpAddress, @Nullable BillingItem billingItem, @Nullable OperatingSystem operatingSystem, @Nullable String operatingSystemReferenceCode, @Nullable Datacenter datacenter, @Nullable PowerState powerState, @Nullable SoftwareLicense softwareLicense, int activeTransactionCount, @Nullable Set<VirtualGuestBlockDevice> blockDevices, boolean localDiskFlag, @Nullable VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup, @Nullable Set<VirtualGuestNetworkComponent> networkComponents, @Nullable Set<TagReference> tagReferences) {
        this.accountId = accountId;
        this.createDate = createDate;
        this.dedicatedAccountHostOnly = dedicatedAccountHostOnly;
        this.domain = domain;
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        this.hostname = hostname;
        this.id = id;
        this.lastVerifiedDate = lastVerifiedDate;
        this.maxCpu = maxCpu;
        this.maxCpuUnits = maxCpuUnits;
        this.maxMemory = maxMemory;
        this.metricPollDate = metricPollDate;
        this.modifyDate = modifyDate;
        this.notes = notes;
        this.privateNetworkOnly = privateNetworkOnly;
        this.startCpus = startCpus;
        this.statusId = statusId;
        this.uuid = uuid;
        this.primaryBackendIpAddress = primaryBackendIpAddress;
        this.primaryIpAddress = primaryIpAddress;
        this.blockDevices = blockDevices;
        this.billingItemId = billingItem == null ? 0 : billingItem.id;
        this.operatingSystem = operatingSystem;
        this.operatingSystemReferenceCode = operatingSystemReferenceCode;
        this.datacenter = datacenter;
        this.powerState = powerState;
        this.softwareLicense = softwareLicense;
        this.activeTransactionCount = activeTransactionCount;
        this.localDiskFlag = localDiskFlag;
        this.blockDeviceTemplateGroup = blockDeviceTemplateGroup;
        this.networkComponents = networkComponents;
        this.tagReferences = tagReferences;
    }

    public int getAccountId() {
        return this.accountId;
    }

    @Nullable
    public Date getCreateDate() {
        return this.createDate;
    }

    public boolean isDedicatedAccountHostOnly() {
        return this.dedicatedAccountHostOnly;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getFullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public Date getLastVerifiedDate() {
        return this.lastVerifiedDate;
    }

    public int getMaxCpu() {
        return this.maxCpu;
    }

    @Nullable
    public String getMaxCpuUnits() {
        return this.maxCpuUnits;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    @Nullable
    public Date getMetricPollDate() {
        return this.metricPollDate;
    }

    @Nullable
    public Date getModifyDate() {
        return this.modifyDate;
    }

    @Nullable
    public String getNotes() {
        return this.notes;
    }

    public boolean isPrivateNetworkOnly() {
        return this.privateNetworkOnly;
    }

    public int getStartCpus() {
        return this.startCpus;
    }

    public int getStatusId() {
        return this.statusId;
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    @Nullable
    public String getPrimaryBackendIpAddress() {
        return this.primaryBackendIpAddress;
    }

    @Nullable
    public String getPrimaryIpAddress() {
        return this.primaryIpAddress;
    }

    public int getBillingItemId() {
        return this.billingItemId;
    }

    @Nullable
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOperatingSystemReferenceCode() {
        return this.operatingSystemReferenceCode;
    }

    @Nullable
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Nullable
    public SoftwareLicense getSoftwareLicense() {
        return this.softwareLicense;
    }

    @Nullable
    public PowerState getPowerState() {
        return this.powerState;
    }

    @Nullable
    public int getActiveTransactionCount() {
        return this.activeTransactionCount;
    }

    @Nullable
    public Set<VirtualGuestBlockDevice> getVirtualGuestBlockDevices() {
        return this.blockDevices;
    }

    public boolean isLocalDiskFlag() {
        return this.localDiskFlag;
    }

    public VirtualGuestBlockDeviceTemplateGroup getVirtualGuestBlockDeviceTemplateGroup() {
        return this.blockDeviceTemplateGroup;
    }

    @Nullable
    public Set<VirtualGuestNetworkComponent> getVirtualGuestNetworkComponents() {
        return this.networkComponents;
    }

    @Nullable
    public Set<TagReference> getTagReferences() {
        return this.tagReferences;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accountId, this.createDate, this.dedicatedAccountHostOnly, this.domain, this.fullyQualifiedDomainName, this.hostname, this.id, this.lastVerifiedDate, this.maxCpu, this.maxCpuUnits, this.maxMemory, this.metricPollDate, this.modifyDate, this.notes, this.privateNetworkOnly, this.startCpus, this.statusId, this.uuid, this.primaryBackendIpAddress, this.primaryIpAddress, this.billingItemId, this.operatingSystem, this.datacenter, this.powerState, this.softwareLicense, this.blockDevices, this.localDiskFlag, this.blockDeviceTemplateGroup, this.tagReferences});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualGuest that = (VirtualGuest)VirtualGuest.class.cast(obj);
        return Objects.equal((Object)this.accountId, (Object)that.accountId) && Objects.equal((Object)this.createDate, (Object)that.createDate) && Objects.equal((Object)this.dedicatedAccountHostOnly, (Object)that.dedicatedAccountHostOnly) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.fullyQualifiedDomainName, (Object)that.fullyQualifiedDomainName) && Objects.equal((Object)this.hostname, (Object)that.hostname) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.lastVerifiedDate, (Object)that.lastVerifiedDate) && Objects.equal((Object)this.maxCpu, (Object)that.maxCpu) && Objects.equal((Object)this.maxCpuUnits, (Object)that.maxCpuUnits) && Objects.equal((Object)this.maxMemory, (Object)that.maxMemory) && Objects.equal((Object)this.metricPollDate, (Object)that.metricPollDate) && Objects.equal((Object)this.modifyDate, (Object)that.modifyDate) && Objects.equal((Object)this.notes, (Object)that.notes) && Objects.equal((Object)this.privateNetworkOnly, (Object)that.privateNetworkOnly) && Objects.equal((Object)this.startCpus, (Object)that.startCpus) && Objects.equal((Object)this.statusId, (Object)that.statusId) && Objects.equal((Object)this.uuid, (Object)that.uuid) && Objects.equal((Object)this.primaryBackendIpAddress, (Object)that.primaryBackendIpAddress) && Objects.equal((Object)this.primaryIpAddress, (Object)that.primaryIpAddress) && Objects.equal((Object)this.billingItemId, (Object)that.billingItemId) && Objects.equal((Object)this.operatingSystem, (Object)that.operatingSystem) && Objects.equal((Object)this.operatingSystemReferenceCode, (Object)that.operatingSystemReferenceCode) && Objects.equal((Object)this.datacenter, (Object)that.datacenter) && Objects.equal((Object)this.powerState, (Object)that.powerState) && Objects.equal((Object)this.softwareLicense, (Object)that.softwareLicense) && Objects.equal(this.blockDevices, that.blockDevices) && Objects.equal((Object)this.localDiskFlag, (Object)that.localDiskFlag) && Objects.equal((Object)this.blockDeviceTemplateGroup, (Object)that.blockDeviceTemplateGroup) && Objects.equal(this.networkComponents, that.networkComponents) && Objects.equal(this.tagReferences, that.tagReferences);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("accountId", this.accountId).add("createDate", (Object)this.createDate).add("dedicatedAccountHostOnly", this.dedicatedAccountHostOnly).add("domain", (Object)this.domain).add("fullyQualifiedDomainName", (Object)this.fullyQualifiedDomainName).add("hostname", (Object)this.hostname).add("id", this.id).add("lastVerifiedDate", (Object)this.lastVerifiedDate).add("maxCpu", this.maxCpu).add("maxCpuUnits", (Object)this.maxCpuUnits).add("maxMemory", this.maxMemory).add("metricPollDate", (Object)this.metricPollDate).add("modifyDate", (Object)this.modifyDate).add("notes", (Object)this.notes).add("privateNetworkOnly", this.privateNetworkOnly).add("startCpus", this.startCpus).add("statusId", this.statusId).add("uuid", (Object)this.uuid).add("primaryBackendIpAddress", (Object)this.primaryBackendIpAddress).add("primaryIpAddress", (Object)this.primaryIpAddress).add("billingItemId", this.billingItemId).add("operatingSystem", (Object)this.operatingSystem).add("operatingSystemReferenceCode", (Object)this.operatingSystemReferenceCode).add("datacenter", (Object)this.datacenter).add("powerState", (Object)this.powerState).add("softwareLicense", (Object)this.softwareLicense).add("activeTransactionCount", this.activeTransactionCount).add("blockDevices", this.blockDevices).add("localDiskFlag", this.localDiskFlag).add("blockDeviceTemplateGroup", (Object)this.blockDeviceTemplateGroup).add("networkComponents", this.networkComponents).add("tagReferences", this.tagReferences).toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int accountId;
        protected Date createDate;
        protected boolean dedicatedAccountHostOnly;
        protected String domain;
        protected String fullyQualifiedDomainName;
        protected String hostname;
        protected int id;
        protected Date lastVerifiedDate;
        protected int maxCpu;
        protected String maxCpuUnits;
        protected int maxMemory;
        protected Date metricPollDate;
        protected Date modifyDate;
        protected String notes;
        protected boolean privateNetworkOnly;
        protected int startCpus;
        protected int statusId;
        protected String uuid;
        protected String primaryBackendIpAddress;
        protected String primaryIpAddress;
        protected int billingItemId;
        protected OperatingSystem operatingSystem;
        protected String operatingSystemReferenceCode;
        protected Datacenter datacenter;
        protected PowerState powerState;
        protected SoftwareLicense softwareLicense;
        protected int activeTransactionCount;
        protected Set<VirtualGuestBlockDevice> blockDevices;
        protected boolean localDiskFlag;
        protected VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup;
        protected Set<VirtualGuestNetworkComponent> networkComponents;
        protected Set<TagReference> tagReferences;

        protected abstract T self();

        public T accountId(int accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T createDate(Date createDate) {
            this.createDate = createDate;
            return this.self();
        }

        public T dedicatedAccountHostOnly(boolean dedicatedAccountHostOnly) {
            this.dedicatedAccountHostOnly = dedicatedAccountHostOnly;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T fullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
            return this.self();
        }

        public T hostname(String hostname) {
            this.hostname = hostname;
            return this.self();
        }

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T lastVerifiedDate(Date lastVerifiedDate) {
            this.lastVerifiedDate = lastVerifiedDate;
            return this.self();
        }

        public T maxCpu(int maxCpu) {
            this.maxCpu = maxCpu;
            return this.self();
        }

        public T maxCpuUnits(String maxCpuUnits) {
            this.maxCpuUnits = maxCpuUnits;
            return this.self();
        }

        public T maxMemory(int maxMemory) {
            this.maxMemory = maxMemory;
            return this.self();
        }

        public T metricPollDate(Date metricPollDate) {
            this.metricPollDate = metricPollDate;
            return this.self();
        }

        public T modifyDate(Date modifyDate) {
            this.modifyDate = modifyDate;
            return this.self();
        }

        public T notes(String notes) {
            this.notes = notes;
            return this.self();
        }

        public T privateNetworkOnly(boolean privateNetworkOnly) {
            this.privateNetworkOnly = privateNetworkOnly;
            return this.self();
        }

        public T startCpus(int startCpus) {
            this.startCpus = startCpus;
            return this.self();
        }

        public T statusId(int statusId) {
            this.statusId = statusId;
            return this.self();
        }

        public T uuid(String uuid) {
            this.uuid = uuid;
            return this.self();
        }

        public T primaryBackendIpAddress(String primaryBackendIpAddress) {
            this.primaryBackendIpAddress = primaryBackendIpAddress;
            return this.self();
        }

        public T primaryIpAddress(String primaryIpAddress) {
            this.primaryIpAddress = primaryIpAddress;
            return this.self();
        }

        public T billingItemId(int billingItemId) {
            this.billingItemId = billingItemId;
            return this.self();
        }

        public T operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this.self();
        }

        public T operatingSystemReferenceCode(String operatingSystemReferenceCode) {
            this.operatingSystemReferenceCode = operatingSystemReferenceCode;
            return this.self();
        }

        public T datacenter(Datacenter datacenter) {
            this.datacenter = datacenter;
            return this.self();
        }

        public T powerState(PowerState powerState) {
            this.powerState = powerState;
            return this.self();
        }

        public T softwareLicense(SoftwareLicense softwareLicense) {
            this.softwareLicense = softwareLicense;
            return this.self();
        }

        public T activeTransactionCount(int activeTransactionCount) {
            this.activeTransactionCount = activeTransactionCount;
            return this.self();
        }

        public T blockDevices(Set<VirtualGuestBlockDevice> blockDevices) {
            this.blockDevices = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(blockDevices, (Object)"blockDevices")));
            return this.self();
        }

        public T blockDevices(VirtualGuestBlockDevice ... in) {
            return this.blockDevices((Set<VirtualGuestBlockDevice>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)in, (Object)"blockDevices"))));
        }

        public T localDiskFlag(boolean localDiskFlag) {
            this.localDiskFlag = localDiskFlag;
            return this.self();
        }

        public T blockDeviceTemplateGroup(VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup) {
            this.blockDeviceTemplateGroup = blockDeviceTemplateGroup;
            return this.self();
        }

        public T networkComponents(Set<VirtualGuestNetworkComponent> networkComponents) {
            this.networkComponents = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(networkComponents, (Object)"networkComponents")));
            return this.self();
        }

        public T networkComponents(VirtualGuestNetworkComponent ... in) {
            return this.networkComponents((Set<VirtualGuestNetworkComponent>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)in, (Object)"networkComponents"))));
        }

        public T tagReferences(Set<TagReference> tagReferences) {
            this.tagReferences = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tagReferences, (Object)"tagReferences")));
            return this.self();
        }

        public T tagReferences(TagReference ... in) {
            return this.tagReferences((Set<TagReference>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)in, (Object)"tagReferences"))));
        }

        public VirtualGuest build() {
            return new VirtualGuest(this.accountId, this.createDate, this.dedicatedAccountHostOnly, this.domain, this.fullyQualifiedDomainName, this.hostname, this.id, this.lastVerifiedDate, this.maxCpu, this.maxCpuUnits, this.maxMemory, this.metricPollDate, this.modifyDate, this.notes, this.privateNetworkOnly, this.startCpus, this.statusId, this.uuid, this.primaryBackendIpAddress, this.primaryIpAddress, new BillingItem(this.billingItemId), this.operatingSystem, this.operatingSystemReferenceCode, this.datacenter, this.powerState, this.softwareLicense, this.activeTransactionCount, this.blockDevices, this.localDiskFlag, this.blockDeviceTemplateGroup, this.networkComponents, this.tagReferences);
        }

        public T fromVirtualGuest(VirtualGuest in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.accountId(in.getAccountId())).createDate(in.getCreateDate())).dedicatedAccountHostOnly(in.isDedicatedAccountHostOnly())).domain(in.getDomain())).fullyQualifiedDomainName(in.getFullyQualifiedDomainName())).hostname(in.getHostname())).id(in.getId())).lastVerifiedDate(in.getLastVerifiedDate())).maxCpu(in.getMaxCpu())).maxCpuUnits(in.getMaxCpuUnits())).maxMemory(in.getMaxMemory())).metricPollDate(in.getMetricPollDate())).modifyDate(in.getModifyDate())).notes(in.getNotes())).privateNetworkOnly(in.isPrivateNetworkOnly())).startCpus(in.getStartCpus())).statusId(in.getStatusId())).uuid(in.getUuid())).primaryBackendIpAddress(in.getPrimaryBackendIpAddress())).primaryIpAddress(in.getPrimaryIpAddress())).billingItemId(in.getBillingItemId())).operatingSystem(in.getOperatingSystem())).operatingSystemReferenceCode(in.getOperatingSystemReferenceCode())).datacenter(in.getDatacenter())).powerState(in.getPowerState())).activeTransactionCount(in.getActiveTransactionCount())).localDiskFlag(in.isLocalDiskFlag())).blockDeviceTemplateGroup(in.getVirtualGuestBlockDeviceTemplateGroup())).networkComponents(in.getVirtualGuestNetworkComponents())).tagReferences(in.getTagReferences());
        }
    }

    public static class BillingItem {
        private final int id;

        @ConstructorProperties(value={"id"})
        public BillingItem(int id) {
            this.id = id;
        }

        public String toString() {
            return "[id=" + this.id + "]";
        }
    }

    public static enum State {
        HALTED,
        PAUSED,
        RUNNING,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

