/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.Binder;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.domain.VirtualGuestBlockDevice;
import org.jclouds.softlayer.domain.VirtualGuestNetworkComponent;

public class VirtualGuestToJson
implements Binder {
    private final Json json;

    @Inject
    public VirtualGuestToJson(Json json) {
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof VirtualGuest));
        VirtualGuest virtualGuest = (VirtualGuest)VirtualGuest.class.cast(Preconditions.checkNotNull((Object)input, (Object)"input"));
        request.setPayload(this.buildJson(virtualGuest));
        return request;
    }

    String buildJson(VirtualGuest virtualGuest) {
        TemplateObject templateObject = null;
        String hostname = (String)Preconditions.checkNotNull((Object)virtualGuest.getHostname(), (Object)"hostname");
        String domain = (String)Preconditions.checkNotNull((Object)virtualGuest.getDomain(), (Object)"domain");
        int startCpus = (Integer)Preconditions.checkNotNull((Object)virtualGuest.getStartCpus(), (Object)"startCpus");
        int maxMemory = (Integer)Preconditions.checkNotNull((Object)virtualGuest.getMaxMemory(), (Object)"maxMemory");
        boolean localDiskFlag = (Boolean)Preconditions.checkNotNull((Object)virtualGuest.isLocalDiskFlag(), (Object)"localDiskFlag");
        String datacenterName = (String)Preconditions.checkNotNull((Object)virtualGuest.getDatacenter().getName(), (Object)"datacenterName");
        Set<NetworkComponent> networkComponents = this.getNetworkComponents(virtualGuest);
        if (virtualGuest.getOperatingSystem() != null) {
            String operatingSystemReferenceCode = (String)Preconditions.checkNotNull((Object)virtualGuest.getOperatingSystem().getOperatingSystemReferenceCode(), (Object)"operatingSystemReferenceCode");
            templateObject = new TemplateObject(hostname, domain, startCpus, maxMemory, true, operatingSystemReferenceCode, null, localDiskFlag, new Datacenter(datacenterName), networkComponents, this.getBlockDevices(virtualGuest));
        } else if (virtualGuest.getVirtualGuestBlockDeviceTemplateGroup() != null) {
            String globalIdentifier = (String)Preconditions.checkNotNull((Object)virtualGuest.getVirtualGuestBlockDeviceTemplateGroup().getGlobalIdentifier(), (Object)"blockDeviceTemplateGroup.globalIdentifier");
            templateObject = new TemplateObject(hostname, domain, startCpus, maxMemory, true, null, new BlockDeviceTemplateGroup(globalIdentifier), localDiskFlag, new Datacenter(datacenterName), networkComponents, null);
        }
        return this.json.toJson((Object)ImmutableMap.of((Object)"parameters", (Object)ImmutableList.of(templateObject)));
    }

    private List<BlockDevice> getBlockDevices(VirtualGuest virtualGuest) {
        if (virtualGuest.getVirtualGuestBlockDevices() == null) {
            return null;
        }
        ArrayList blockDevices = Lists.newArrayList();
        for (VirtualGuestBlockDevice blockDevice : virtualGuest.getVirtualGuestBlockDevices()) {
            blockDevices.add(new BlockDevice(blockDevice.getDevice(), blockDevice.getVirtualDiskImage().getCapacity()));
        }
        Collections.sort(blockDevices, new BlockDevicesComparator());
        return ImmutableList.copyOf((Collection)blockDevices);
    }

    private Set<NetworkComponent> getNetworkComponents(VirtualGuest virtualGuest) {
        if (virtualGuest.getVirtualGuestNetworkComponents() == null) {
            return null;
        }
        ImmutableSet.Builder networkComponents = ImmutableSet.builder();
        for (VirtualGuestNetworkComponent networkComponent : virtualGuest.getVirtualGuestNetworkComponents()) {
            networkComponents.add((Object)new NetworkComponent(networkComponent.getSpeed()));
        }
        return networkComponents.build();
    }

    private class BlockDevicesComparator
    implements Comparator<BlockDevice> {
        private BlockDevicesComparator() {
        }

        @Override
        public int compare(BlockDevice b1, BlockDevice b2) {
            return Integer.valueOf(b1.getDevice()).compareTo(Integer.valueOf(b2.getDevice()));
        }
    }

    private class BlockDeviceTemplateGroup {
        private String globalIdentifier;

        private BlockDeviceTemplateGroup(String globalIdentifier) {
            this.globalIdentifier = globalIdentifier;
        }
    }

    private class DiskImage {
        private float capacity;

        private DiskImage(float capacity) {
            this.capacity = capacity;
        }
    }

    private class BlockDevice {
        private String device;
        private DiskImage diskImage;

        public String getDevice() {
            return this.device;
        }

        public DiskImage getDiskImage() {
            return this.diskImage;
        }

        private BlockDevice(String device, float diskImageCapacity) {
            this.device = device;
            this.diskImage = new DiskImage(diskImageCapacity);
        }
    }

    private class NetworkComponent {
        private int maxSpeed;

        private NetworkComponent(int maxSpeed) {
            this.maxSpeed = maxSpeed;
        }
    }

    private class Datacenter {
        private String name;

        private Datacenter(String name) {
            this.name = name;
        }
    }

    private static class TemplateObject {
        private final String hostname;
        private final String domain;
        private final int startCpus;
        private final int maxMemory;
        private final boolean hourlyBillingFlag;
        private final BlockDeviceTemplateGroup blockDeviceTemplateGroup;
        private final String operatingSystemReferenceCode;
        private final boolean localDiskFlag;
        private final Datacenter datacenter;
        private final Set<NetworkComponent> networkComponents;
        private final List<BlockDevice> blockDevices;

        private TemplateObject(String hostname, String domain, int startCpus, int maxMemory, boolean hourlyBillingFlag, String operatingSystemReferenceCode, BlockDeviceTemplateGroup blockDeviceTemplateGroup, boolean localDiskFlag, Datacenter datacenter, Set<NetworkComponent> networkComponents, List<BlockDevice> blockDevices) {
            this.hostname = hostname;
            this.domain = domain;
            this.startCpus = startCpus;
            this.maxMemory = maxMemory;
            this.hourlyBillingFlag = hourlyBillingFlag;
            this.operatingSystemReferenceCode = operatingSystemReferenceCode;
            this.blockDeviceTemplateGroup = blockDeviceTemplateGroup;
            this.localDiskFlag = localDiskFlag;
            this.datacenter = datacenter;
            this.networkComponents = networkComponents;
            this.blockDevices = blockDevices;
        }
    }
}

