/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.name.Named;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Address {
    private final int id;
    private final String country;
    private final String state;
    private final String description;
    private final int accountId;
    @Named(value="address1")
    private final String address;
    private final String city;
    private final String contactName;
    private final int isActive;
    private final int locationId;
    private final String postalCode;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAddress(this);
    }

    @ConstructorProperties(value={"id", "country", "state", "description", "accountId", "address1", "city", "contactName", "isActive", "locationId", "postalCode"})
    protected Address(int id, String country, @Nullable String state, @Nullable String description, int accountId, @Nullable String address, @Nullable String city, @Nullable String contactName, int isActive, int locationId, @Nullable String postalCode) {
        this.id = id;
        this.accountId = (Integer)Preconditions.checkNotNull((Object)accountId, (Object)"accountId");
        this.address = address;
        this.city = city;
        this.contactName = contactName;
        this.isActive = isActive;
        this.locationId = locationId;
        this.postalCode = postalCode;
        this.country = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)country), (Object)("country cannot be null or empty:" + country));
        this.state = state;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getCountry() {
        return this.country;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public int getAccountId() {
        return this.accountId;
    }

    @Nullable
    public String getAddress1() {
        return this.address;
    }

    @Nullable
    public String getCity() {
        return this.city;
    }

    @Nullable
    public String getContactName() {
        return this.contactName;
    }

    @Nullable
    public int isActive() {
        return this.isActive;
    }

    @Nullable
    public int getLocationId() {
        return this.locationId;
    }

    @Nullable
    public String getPostalCode() {
        return this.postalCode;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)Address.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("country", (Object)this.country).add("state", (Object)this.state).add("description", (Object)this.description).add("accountId", this.accountId).add("address", (Object)this.address).add("city", (Object)this.city).add("contactName", (Object)this.contactName).add("isActive", this.isActive).add("locationId", this.locationId).add("postalCode", (Object)this.postalCode).toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String country;
        protected String state;
        protected String description;
        protected int accountId;
        @Named(value="address1")
        protected String address;
        protected String city;
        protected String contactName;
        protected int isActive;
        protected int locationId;
        protected String postalCode;

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T country(String country) {
            this.country = country;
            return this.self();
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T accountId(int accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T address(String address) {
            this.address = address;
            return this.self();
        }

        public T city(String city) {
            this.city = city;
            return this.self();
        }

        public T contactName(String contactName) {
            this.contactName = contactName;
            return this.self();
        }

        public T isActive(int isActive) {
            this.isActive = isActive;
            return this.self();
        }

        public T locationId(int locationId) {
            this.locationId = locationId;
            return this.self();
        }

        public T postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this.self();
        }

        public Address build() {
            return new Address(this.id, this.country, this.state, this.description, this.accountId, this.address, this.city, this.contactName, this.isActive, this.locationId, this.postalCode);
        }

        public T fromAddress(Address in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).country(in.getCountry())).state(in.getState())).description(in.getDescription())).accountId(in.getAccountId())).address(in.getAddress1())).city(in.getCity())).contactName(in.getContactName())).isActive(in.isActive())).locationId(in.getLocationId())).postalCode(in.getPostalCode());
        }
    }
}

